/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation.change.search;

import com.yahoo.config.application.api.ValidationId;
import com.yahoo.config.application.api.ValidationOverrides;
import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.document.SDField;
import com.yahoo.vespa.indexinglanguage.ExpressionConverter;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.OutputExpression;
import com.yahoo.vespa.indexinglanguage.expressions.ScriptExpression;
import com.yahoo.vespa.model.application.validation.change.VespaConfigChangeAction;
import com.yahoo.vespa.model.application.validation.change.VespaRefeedAction;
import com.yahoo.vespa.model.application.validation.change.search.ChangeMessageBuilder;
import com.yahoo.vespa.model.application.validation.change.search.IndexingScriptChangeMessageBuilder;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class IndexingScriptChangeValidator {
    private final Search currentSearch;
    private final Search nextSearch;

    public IndexingScriptChangeValidator(Search currentSearch, Search nextSearch) {
        this.currentSearch = currentSearch;
        this.nextSearch = nextSearch;
    }

    public List<VespaConfigChangeAction> validate(ValidationOverrides overrides, Instant now) {
        ArrayList<VespaConfigChangeAction> result = new ArrayList<VespaConfigChangeAction>();
        for (SDField nextField : this.nextSearch.allConcreteFields()) {
            String fieldName = nextField.getName();
            SDField currentField = this.currentSearch.getConcreteField(fieldName);
            if (currentField == null) continue;
            this.validateScripts(currentField, nextField, overrides, now).ifPresent(r -> result.add((VespaConfigChangeAction)r));
        }
        return result;
    }

    private Optional<VespaConfigChangeAction> validateScripts(SDField currentField, SDField nextField, ValidationOverrides overrides, Instant now) {
        ScriptExpression nextScript;
        ScriptExpression currentScript = currentField.getIndexingScript();
        if (!IndexingScriptChangeValidator.equalScripts(currentScript, nextScript = nextField.getIndexingScript())) {
            ChangeMessageBuilder messageBuilder = new ChangeMessageBuilder(nextField.getName());
            new IndexingScriptChangeMessageBuilder(this.currentSearch, currentField, this.nextSearch, nextField).populate(messageBuilder);
            messageBuilder.addChange("indexing script", currentScript.toString(), nextScript.toString());
            return Optional.of(VespaRefeedAction.of(ValidationId.indexingChange.value(), overrides, messageBuilder.build(), now));
        }
        return Optional.empty();
    }

    static boolean equalScripts(ScriptExpression currentScript, ScriptExpression nextScript) {
        return IndexingScriptChangeValidator.removeOutputExpressions(currentScript).equals((Object)IndexingScriptChangeValidator.removeOutputExpressions(nextScript));
    }

    private static ScriptExpression removeOutputExpressions(ScriptExpression script) {
        ScriptExpression retval = (ScriptExpression)new OutputExpressionRemover().convert((Expression)script);
        return retval;
    }

    private static class OutputExpressionRemover
    extends ExpressionConverter {
        private OutputExpressionRemover() {
        }

        protected boolean shouldConvert(Expression exp) {
            return exp instanceof OutputExpression;
        }

        protected Expression doConvert(Expression exp) {
            if (exp instanceof OutputExpression) {
                return null;
            }
            return exp;
        }
    }
}

