/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.documentmodel;

import com.yahoo.document.DataType;
import com.yahoo.documentmodel.DataTypeCollection;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class DataTypeRepo
implements DataTypeCollection {
    private Map<Integer, DataType> typeById = new LinkedHashMap<Integer, DataType>();
    private Map<String, DataType> typeByName = new LinkedHashMap<String, DataType>();

    @Override
    public DataType getDataType(String name) {
        return this.typeByName.get(name);
    }

    @Override
    public DataType getDataType(int id) {
        return this.typeById.get(id);
    }

    @Override
    public Collection<DataType> getTypes() {
        return this.typeById.values();
    }

    public DataTypeRepo add(DataType type) {
        if (this.typeByName.containsKey(type.getName()) || this.typeById.containsKey(type.getId())) {
            throw new IllegalStateException("Data type '" + type.getName() + "', id '" + type.getId() + "' is already registered.");
        }
        this.typeByName.put(type.getName(), type);
        this.typeById.put(type.getId(), type);
        return this;
    }

    public DataTypeRepo addAll(DataTypeCollection repo) {
        for (DataType dataType : repo.getTypes()) {
            this.add(dataType);
        }
        return this;
    }

    public DataTypeRepo replace(DataType type) {
        if (!this.typeByName.containsKey(type.getName()) || !this.typeById.containsKey(type.getId())) {
            throw new IllegalStateException("Data type '" + type.getName() + "' is not registered.");
        }
        this.typeByName.remove(type.getName());
        this.typeByName.put(type.getName(), type);
        this.typeById.remove(type.getId());
        this.typeById.put(type.getId(), type);
        return this;
    }
}

