/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition;

import com.yahoo.searchdefinition.DefaultRankProfile;
import com.yahoo.searchdefinition.ImmutableSearch;
import com.yahoo.searchdefinition.RankProfile;
import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.UnrankedRankProfile;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class RankProfileRegistry {
    private final Map<RankProfile, ImmutableSearch> rankProfileToSearch = new LinkedHashMap<RankProfile, ImmutableSearch>();
    private final Map<ImmutableSearch, Map<String, RankProfile>> rankProfiles = new LinkedHashMap<ImmutableSearch, Map<String, RankProfile>>();
    static final Set<String> overridableRankProfileNames = new HashSet<String>(Arrays.asList("default", "unranked"));

    public static RankProfileRegistry createRankProfileRegistryWithBuiltinRankProfiles(Search search) {
        RankProfileRegistry rankProfileRegistry = new RankProfileRegistry();
        rankProfileRegistry.add(new DefaultRankProfile(search, rankProfileRegistry));
        rankProfileRegistry.add(new UnrankedRankProfile(search, rankProfileRegistry));
        return rankProfileRegistry;
    }

    public void add(RankProfile rankProfile) {
        if (!this.rankProfiles.containsKey(rankProfile.getSearch())) {
            this.rankProfiles.put(rankProfile.getSearch(), new LinkedHashMap());
        }
        this.checkForDuplicate(rankProfile);
        this.rankProfiles.get(rankProfile.getSearch()).put(rankProfile.getName(), rankProfile);
        this.rankProfileToSearch.put(rankProfile, rankProfile.getSearch());
    }

    private void checkForDuplicate(RankProfile rankProfile) {
        String rankProfileName = rankProfile.getName();
        RankProfile existingRangProfileWithSameName = this.rankProfiles.get(rankProfile.getSearch()).get(rankProfileName);
        if (existingRangProfileWithSameName == null) {
            return;
        }
        if (!overridableRankProfileNames.contains(rankProfileName)) {
            throw new IllegalArgumentException("Cannot add rank profile '" + rankProfileName + "' in search definition '" + rankProfile.getSearch().getName() + "', since it already exists");
        }
    }

    public RankProfile get(ImmutableSearch search, String name) {
        Map<String, RankProfile> profiles = this.rankProfiles.get(search);
        if (profiles == null) {
            return null;
        }
        return profiles.get(name);
    }

    public Set<RankProfile> all() {
        return this.rankProfileToSearch.keySet();
    }

    public Collection<RankProfile> rankProfilesOf(ImmutableSearch search) {
        Map<String, RankProfile> mapping = this.rankProfiles.get(search);
        if (mapping == null) {
            return Collections.emptyList();
        }
        return mapping.values();
    }
}

