/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.content;

import com.yahoo.vespa.config.content.core.StorDistributormanagerConfig;
import com.yahoo.vespa.model.builder.xml.dom.ModelElement;

public class BucketSplitting
implements StorDistributormanagerConfig.Producer {
    Integer maxDocuments;
    Integer splitSize;
    Integer minSplitCount;

    public BucketSplitting(Integer maxDocuments, Integer splitSize, Integer minSplitCount) {
        this.maxDocuments = maxDocuments;
        this.splitSize = splitSize;
        this.minSplitCount = minSplitCount;
    }

    public void getConfig(StorDistributormanagerConfig.Builder builder) {
        if (this.maxDocuments != null) {
            builder.splitcount(this.maxDocuments.intValue());
            builder.joincount(this.maxDocuments / 2);
        }
        if (this.splitSize != null) {
            builder.splitsize(this.splitSize.intValue());
            builder.joinsize(this.splitSize / 2);
        }
        if (this.minSplitCount != null) {
            builder.minsplitcount(this.minSplitCount.intValue());
        }
        builder.inlinebucketsplitting(false);
    }

    public static class Builder {
        public BucketSplitting build(ModelElement clusterElem) {
            ModelElement tuning = clusterElem.getChild("tuning");
            if (tuning == null) {
                return new BucketSplitting(null, null, null);
            }
            ModelElement bucketSplitting = tuning.getChild("bucket-splitting");
            if (bucketSplitting != null) {
                Integer maxDocuments = bucketSplitting.getIntegerAttribute("max-documents");
                Integer splitSize = bucketSplitting.getIntegerAttribute("max-size");
                Integer minSplitCount = bucketSplitting.getIntegerAttribute("minimum-bits");
                return new BucketSplitting(maxDocuments, splitSize, minSplitCount);
            }
            return new BucketSplitting(null, null, null);
        }
    }
}

