/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.ml;

import com.yahoo.path.Path;

public class ModelName {
    private String namespace;
    private String name;
    private String fullName;

    public ModelName(String name) {
        this(null, name);
    }

    public ModelName(String namespace, Path modelPath, boolean pathIsFile) {
        this(namespace, ModelName.stripFileEndingIfFile(modelPath, pathIsFile).toString().replace("/", "_"));
    }

    private ModelName(String namespace, String name) {
        this.namespace = namespace;
        this.name = name;
        this.fullName = (String)(namespace != null ? namespace + "." : "") + name;
    }

    private static Path stripFileEndingIfFile(Path path, boolean pathIsFile) {
        if (!pathIsFile) {
            return path;
        }
        int dotIndex = path.last().lastIndexOf(".");
        if (dotIndex <= 0) {
            return path;
        }
        return path.withLast(path.last().substring(0, dotIndex));
    }

    public boolean isGlobal() {
        return this.namespace == null;
    }

    public String namespace() {
        return this.namespace;
    }

    public String localName() {
        return this.name;
    }

    public String fullName() {
        return this.fullName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModelName)) {
            return false;
        }
        return ((ModelName)o).fullName.equals(this.fullName);
    }

    public int hashCode() {
        return this.fullName.hashCode();
    }

    public String toString() {
        return this.fullName;
    }
}

