/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation;

import com.yahoo.config.application.api.DeploymentInstanceSpec;
import com.yahoo.config.application.api.DeploymentSpec;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.vespa.model.VespaModel;
import com.yahoo.vespa.model.application.validation.Validator;
import com.yahoo.vespa.model.container.ContainerModel;
import java.io.Reader;
import java.util.List;
import java.util.Optional;

public class DeploymentSpecValidator
extends Validator {
    @Override
    public void validate(VespaModel model, DeployState deployState) {
        Optional deployment = deployState.getApplicationPackage().getDeployment();
        if (deployment.isEmpty()) {
            return;
        }
        Reader deploymentReader = (Reader)deployment.get();
        DeploymentSpec deploymentSpec = DeploymentSpec.fromXml((Reader)deploymentReader);
        List<ContainerModel> containers = model.getRoot().configModelRepo().getModels(ContainerModel.class);
        for (DeploymentInstanceSpec instance : deploymentSpec.instances()) {
            instance.globalServiceId().ifPresent(globalServiceId -> {
                if (containers.stream().noneMatch(container -> container.getCluster().getName().equals(globalServiceId))) {
                    throw new IllegalArgumentException("The global-service-id in " + instance + ", '" + globalServiceId + "' specified in deployment.xml does not match any container cluster id");
                }
            });
        }
    }
}

