/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.admin.clustercontroller;

import com.yahoo.cloud.config.ZookeeperServerConfig;
import com.yahoo.component.ComponentSpecification;
import com.yahoo.config.model.api.container.ContainerServiceType;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.container.BundlesConfig;
import com.yahoo.container.bundle.BundleInstantiationSpecification;
import com.yahoo.log.LogLevel;
import com.yahoo.osgi.provider.model.ComponentModel;
import com.yahoo.vespa.config.content.FleetcontrollerConfig;
import com.yahoo.vespa.defaults.Defaults;
import com.yahoo.vespa.model.application.validation.RestartConfigs;
import com.yahoo.vespa.model.container.Container;
import com.yahoo.vespa.model.container.component.AccessLogComponent;
import com.yahoo.vespa.model.container.component.Component;
import com.yahoo.vespa.model.container.component.Handler;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;

@RestartConfigs(value={FleetcontrollerConfig.class, ZookeeperServerConfig.class})
public class ClusterControllerContainer
extends Container
implements BundlesConfig.Producer,
ZookeeperServerConfig.Producer {
    private static final ComponentSpecification CLUSTERCONTROLLER_BUNDLE = new ComponentSpecification("clustercontroller-apps");
    private static final ComponentSpecification ZKFACADE_BUNDLE = new ComponentSpecification("zkfacade");
    private final Set<String> bundles = new TreeSet<String>();

    public ClusterControllerContainer(AbstractConfigProducer parent, int index, boolean runStandaloneZooKeeper, boolean isHosted) {
        super(parent, "" + index, index);
        this.addHandler(new Handler(new ComponentModel(new BundleInstantiationSpecification(new ComponentSpecification("clustercontroller-status"), new ComponentSpecification("com.yahoo.vespa.clustercontroller.apps.clustercontroller.StatusHandler"), CLUSTERCONTROLLER_BUNDLE))), "clustercontroller-status/*");
        this.addHandler(new Handler(new ComponentModel(new BundleInstantiationSpecification(new ComponentSpecification("clustercontroller-state-restapi-v2"), new ComponentSpecification("com.yahoo.vespa.clustercontroller.apps.clustercontroller.StateRestApiV2Handler"), CLUSTERCONTROLLER_BUNDLE))), "cluster/v2/*");
        if (runStandaloneZooKeeper) {
            this.addComponent(new Component(new ComponentModel(new BundleInstantiationSpecification(new ComponentSpecification("clustercontroller-zkrunner"), new ComponentSpecification("com.yahoo.vespa.zookeeper.ZooKeeperServer"), ZKFACADE_BUNDLE))));
            this.addComponent(new Component(new ComponentModel(new BundleInstantiationSpecification(new ComponentSpecification("clustercontroller-zkprovider"), new ComponentSpecification("com.yahoo.vespa.clustercontroller.apps.clustercontroller.StandaloneZooKeeperProvider"), CLUSTERCONTROLLER_BUNDLE))));
        } else {
            this.addComponent(new Component(new ComponentModel(new BundleInstantiationSpecification(new ComponentSpecification("clustercontroller-zkprovider"), new ComponentSpecification("com.yahoo.vespa.clustercontroller.apps.clustercontroller.DummyZooKeeperProvider"), CLUSTERCONTROLLER_BUNDLE))));
        }
        this.addBundle("file:" + Defaults.getDefaults().underVespaHome("lib/jars/clustercontroller-apps-jar-with-dependencies.jar"));
        this.addBundle("file:" + Defaults.getDefaults().underVespaHome("lib/jars/clustercontroller-apputil-jar-with-dependencies.jar"));
        this.addBundle("file:" + Defaults.getDefaults().underVespaHome("lib/jars/clustercontroller-core-jar-with-dependencies.jar"));
        this.addBundle("file:" + Defaults.getDefaults().underVespaHome("lib/jars/clustercontroller-utils-jar-with-dependencies.jar"));
        this.addBundle("file:" + Defaults.getDefaults().underVespaHome("lib/jars/zkfacade-jar-with-dependencies.jar"));
        log.log((Level)LogLevel.DEBUG, "Adding access log for cluster controller ...");
        this.addComponent(new AccessLogComponent(AccessLogComponent.AccessLogType.jsonAccessLog, "controller", isHosted));
    }

    @Override
    public int getWantedPort() {
        return 19050;
    }

    @Override
    public boolean requiresWantedPort() {
        return this.index() == 0;
    }

    @Override
    public ContainerServiceType myServiceType() {
        return ContainerServiceType.CLUSTERCONTROLLER_CONTAINER;
    }

    private void addHandler(Handler h, String binding) {
        h.addServerBindings("http://*/" + binding);
        super.addHandler(h);
    }

    public void addBundle(String bundlePath) {
        this.bundles.add(bundlePath);
    }

    public void getConfig(BundlesConfig.Builder builder) {
        for (String bundle : this.bundles) {
            builder.bundle(bundle);
        }
    }

    public void getConfig(ZookeeperServerConfig.Builder builder) {
        builder.myid(this.index());
    }
}

