/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.derived;

import com.yahoo.document.DataTypeName;
import com.yahoo.searchdefinition.DocumentReference;
import com.yahoo.searchdefinition.DocumentReferences;
import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.document.SDDocumentType;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SearchOrderer {
    private final Map<DataTypeName, Search> documentNameToSearch = new HashMap<DataTypeName, Search>();

    public List<Search> order(List<Search> unordered) {
        unordered.sort(Comparator.comparing(Search::getName));
        this.indexOnDocumentName(unordered);
        ArrayList<Search> ordered = new ArrayList<Search>(unordered.size());
        ArrayList<Search> moveOutwards = new ArrayList<Search>();
        for (Search search : unordered) {
            if (this.allDependenciesAlreadyEmitted(ordered, search)) {
                this.addOrdered(ordered, search, moveOutwards);
                continue;
            }
            moveOutwards.add(search);
        }
        ordered.addAll(moveOutwards);
        this.documentNameToSearch.clear();
        return ordered;
    }

    private void addOrdered(List<Search> ordered, Search search, List<Search> moveOutwards) {
        Search eligibleMove;
        ordered.add(search);
        do {
            if ((eligibleMove = this.removeFirstEntryWithFullyEmittedDependencies(moveOutwards, ordered)) == null) continue;
            ordered.add(eligibleMove);
        } while (eligibleMove != null);
    }

    private Search removeFirstEntryWithFullyEmittedDependencies(List<Search> moveOutwards, List<Search> ordered) {
        for (Search move : moveOutwards) {
            if (!this.allDependenciesAlreadyEmitted(ordered, move)) continue;
            moveOutwards.remove(move);
            return move;
        }
        return null;
    }

    private boolean allDependenciesAlreadyEmitted(List<Search> alreadyOrdered, Search search) {
        if (search.getDocument() == null) {
            return true;
        }
        SDDocumentType document = search.getDocument();
        return this.allInheritedDependenciesEmitted(alreadyOrdered, document) && SearchOrderer.allReferenceDependenciesEmitted(alreadyOrdered, document);
    }

    private boolean allInheritedDependenciesEmitted(List<Search> alreadyOrdered, SDDocumentType document) {
        for (SDDocumentType sdoc : document.getInheritedTypes()) {
            Search inheritedSearch;
            DataTypeName inheritedName = sdoc.getDocumentName();
            if ("document".equals(inheritedName.getName()) || alreadyOrdered.contains(inheritedSearch = this.documentNameToSearch.get(inheritedName))) continue;
            return false;
        }
        return true;
    }

    private static boolean allReferenceDependenciesEmitted(List<Search> alreadyOrdered, SDDocumentType document) {
        DocumentReferences documentReferences = document.getDocumentReferences().orElseThrow(() -> new IllegalStateException("Missing document references. Should have been processed by now."));
        return documentReferences.stream().map(Map.Entry::getValue).map(DocumentReference::targetSearch).allMatch(alreadyOrdered::contains);
    }

    private void indexOnDocumentName(List<Search> searches) {
        this.documentNameToSearch.clear();
        for (Search search : searches) {
            if (search.getDocument() == null) continue;
            this.documentNameToSearch.put(search.getDocument().getDocumentName(), search);
        }
    }
}

