/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model;

import com.yahoo.component.Version;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.model.api.HostInfo;
import com.yahoo.config.provision.ClusterMembership;
import com.yahoo.config.provision.Flavor;
import com.yahoo.vespa.model.AbstractService;
import com.yahoo.vespa.model.Host;
import com.yahoo.vespa.model.HostPorts;
import com.yahoo.vespa.model.Service;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class HostResource
implements Comparable<HostResource> {
    private final HostPorts hostPorts;
    private final Host host;
    private final Map<String, Service> services = new LinkedHashMap<String, Service>();
    private Set<ClusterMembership> clusterMemberships = new LinkedHashSet<ClusterMembership>();
    private Optional<Flavor> flavor = Optional.empty();
    private final Optional<Version> version;

    public HostPorts ports() {
        return this.hostPorts;
    }

    public HostResource(Host host) {
        this(host, Optional.empty());
    }

    public HostResource(Host host, Optional<Version> version) {
        this.hostPorts = new HostPorts(host.getHostname());
        this.host = host;
        this.version = version;
    }

    public Host getHost() {
        return this.host;
    }

    public Optional<Version> version() {
        return this.version;
    }

    List<Integer> allocateService(DeployLogger deployLogger, AbstractService service, int wantedPort) {
        this.ports().useLogger(deployLogger);
        List<Integer> ports = this.hostPorts.allocatePorts(service, wantedPort);
        assert (this.getService(service.getServiceName()) == null) : "There is already a service with name '" + service.getServiceName() + "' registered on " + this + ". Most likely a programming error - all service classes must have unique names, even in different packages!";
        this.services.put(service.getServiceName(), service);
        return ports;
    }

    public Service getService(String sentinelName) {
        return this.services.get(sentinelName);
    }

    public List<Service> getServices() {
        return new ArrayList<Service>(this.services.values());
    }

    public HostInfo getHostInfo() {
        return new HostInfo(this.getHostname(), (Collection)this.services.values().stream().map(Service::getServiceInfo).collect(Collectors.toSet()));
    }

    public void setFlavor(Optional<Flavor> flavor) {
        this.flavor = flavor;
    }

    public Optional<Flavor> getFlavor() {
        return this.flavor;
    }

    public void addClusterMembership(ClusterMembership clusterMembership) {
        if (clusterMembership != null) {
            this.clusterMemberships.add(clusterMembership);
        }
    }

    public Set<ClusterMembership> clusterMemberships() {
        return Collections.unmodifiableSet(this.clusterMemberships);
    }

    public Optional<ClusterMembership> primaryClusterMembership() {
        return this.clusterMemberships().stream().sorted(HostResource::compareClusters).findFirst();
    }

    private static int compareClusters(ClusterMembership cluster1, ClusterMembership cluster2) {
        return cluster2.cluster().type().compareTo((Enum)cluster1.cluster().type());
    }

    public String toString() {
        return "host '" + this.host.getHostname() + "'";
    }

    public String getHostname() {
        return this.host.getHostname();
    }

    public int hashCode() {
        return this.host.hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof HostResource)) {
            return false;
        }
        return ((HostResource)other).host.equals(this.host);
    }

    @Override
    public int compareTo(HostResource other) {
        return this.host.compareTo(other.host);
    }

    public int comparePrimarilyByIndexTo(HostResource other) {
        Optional<ClusterMembership> thisMembership = this.primaryClusterMembership();
        Optional<ClusterMembership> otherMembership = other.primaryClusterMembership();
        if (thisMembership.isPresent() && otherMembership.isPresent()) {
            return Integer.compare(thisMembership.get().index(), otherMembership.get().index());
        }
        return this.getHostname().compareTo(other.getHostname());
    }

    public static List<HostResource> pickHosts(List<HostResource> hostsSelectedByIndex, int count) {
        return hostsSelectedByIndex.subList(0, Math.min(count, hostsSelectedByIndex.size()));
    }

    public static List<HostResource> pickHosts(Collection<HostResource> hosts, int count, int targetHostsSelectedByIndex) {
        targetHostsSelectedByIndex = Math.min(Math.min(targetHostsSelectedByIndex, count), hosts.size());
        List<HostResource> hostsSortedByName = new ArrayList<HostResource>(hosts);
        Collections.sort(hostsSortedByName);
        List<HostResource> hostsSortedByIndex = new ArrayList<HostResource>(hosts);
        hostsSortedByIndex.sort((a, b) -> a.comparePrimarilyByIndexTo((HostResource)b));
        hostsSortedByName = hostsSortedByName.subList(0, Math.min(count - targetHostsSelectedByIndex, hostsSortedByName.size()));
        hostsSortedByIndex.removeAll(hostsSortedByName);
        hostsSortedByIndex = hostsSortedByIndex.subList(0, Math.min(targetHostsSelectedByIndex, hostsSortedByIndex.size()));
        ArrayList<HostResource> finalHosts = new ArrayList<HostResource>();
        finalHosts.addAll(hostsSortedByName);
        finalHosts.addAll(hostsSortedByIndex);
        return finalHosts;
    }
}

