/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container;

import com.yahoo.component.ComponentId;
import com.yahoo.component.ComponentSpecification;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.container.ComponentsConfig;
import com.yahoo.container.QrConfig;
import com.yahoo.container.core.ContainerHttpConfig;
import com.yahoo.container.jdisc.ContainerMbusConfig;
import com.yahoo.container.jdisc.JdiscBindingsConfig;
import com.yahoo.search.config.QrStartConfig;
import com.yahoo.vespa.defaults.Defaults;
import com.yahoo.vespa.model.AbstractService;
import com.yahoo.vespa.model.application.validation.RestartConfigs;
import com.yahoo.vespa.model.container.ContainerCluster;
import com.yahoo.vespa.model.container.component.Component;
import com.yahoo.vespa.model.container.component.ComponentGroup;
import com.yahoo.vespa.model.container.component.ComponentsConfigGenerator;
import com.yahoo.vespa.model.container.component.DiscBindingsConfigGenerator;
import com.yahoo.vespa.model.container.component.Handler;
import com.yahoo.vespa.model.container.component.SimpleComponent;
import com.yahoo.vespa.model.container.http.ConnectorFactory;
import com.yahoo.vespa.model.container.http.Http;
import com.yahoo.vespa.model.container.http.JettyHttpServer;
import com.yahoo.vespa.model.filedistribution.FileDistributionConfigProducer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@RestartConfigs(value={QrStartConfig.class, QrConfig.class})
public class Container
extends AbstractService
implements QrConfig.Producer,
ComponentsConfig.Producer,
JdiscBindingsConfig.Producer,
ContainerHttpConfig.Producer,
ContainerMbusConfig.Producer {
    public static final int BASEPORT = Defaults.getDefaults().vespaWebServicePort();
    public static final String SINGLENODE_CONTAINER_SERVICESPEC = "default_singlenode_container";
    private final AbstractConfigProducer parent;
    private final String name;
    private final boolean isHostedVespa;
    private String clusterName = null;
    private Optional<String> hostResponseHeaderKey = Optional.empty();
    private final boolean retired;
    private final int index;
    private final ComponentGroup<Handler<?>> handlers = new ComponentGroup(this, "handler");
    private final ComponentGroup<Component<?, ?>> components = new ComponentGroup(this, "components");
    private final JettyHttpServer defaultHttpServer = new JettyHttpServer(new ComponentId("DefaultHttpServer"));
    private final List<PortOverride> portOverrides;
    private final int numHttpServerPorts;
    private static final int numRpcServerPorts = 2;
    private static final String defaultHostedJVMArgs = "-XX:+UseOSErrorReporting -XX:+SuppressFatalErrorMessage";
    private String myServiceType = null;

    public Container(AbstractConfigProducer parent, String name, int index, boolean isHostedVespa) {
        this(parent, name, Collections.emptyList(), index, isHostedVespa);
    }

    public Container(AbstractConfigProducer parent, String name, boolean retired, int index, boolean isHostedVespa) {
        this(parent, name, retired, Collections.emptyList(), index, isHostedVespa);
    }

    public Container(AbstractConfigProducer parent, String name, List<PortOverride> portOverrides, int index, boolean isHostedVespa) {
        this(parent, name, false, portOverrides, index, isHostedVespa);
    }

    public Container(AbstractConfigProducer parent, String name, boolean retired, List<PortOverride> portOverrides, int index, boolean isHostedVespa) {
        super(parent, name);
        this.name = name;
        this.parent = parent;
        this.isHostedVespa = isHostedVespa;
        this.portOverrides = Collections.unmodifiableList(new ArrayList<PortOverride>(portOverrides));
        this.retired = retired;
        this.index = index;
        if (this.getHttp() == null) {
            this.numHttpServerPorts = 2;
            this.addChild(this.defaultHttpServer);
        } else {
            this.numHttpServerPorts = this.getHttp().getHttpServer() == null ? 0 : this.getHttp().getHttpServer().getConnectorFactories().size();
        }
        this.addBuiltinHandlers();
        this.addChild(new SimpleComponent("com.yahoo.container.jdisc.ConfiguredApplication$ApplicationContext"));
    }

    public boolean isRetired() {
        return this.retired;
    }

    public ComponentGroup<Handler<?>> getHandlers() {
        return this.handlers;
    }

    public ComponentGroup getComponents() {
        return this.components;
    }

    public void addComponent(Component c) {
        this.components.addComponent(c);
    }

    public void addHandler(Handler h) {
        this.handlers.addComponent(h);
    }

    public void setHostResponseHeaderKey(Optional<String> hostResponseheaderKey) {
        Objects.requireNonNull(hostResponseheaderKey, "HostResponseheaderKey cannot be null");
        this.hostResponseHeaderKey = hostResponseheaderKey;
    }

    public Http getHttp() {
        return this.parent instanceof ContainerCluster ? ((ContainerCluster)this.parent).getHttp() : null;
    }

    public JettyHttpServer getDefaultHttpServer() {
        return this.defaultHttpServer;
    }

    public int index() {
        return this.index;
    }

    public void addBuiltinHandlers() {
    }

    @Override
    public void initService(DeployLogger deployLogger) {
        if (this.isInitialized()) {
            return;
        }
        super.initService(deployLogger);
        if (this.getHttp() == null) {
            this.initDefaultJettyConnector();
        } else {
            this.reserveHttpPortsPrepended();
        }
        this.tagServers();
    }

    private void tagServers() {
        if (this.numHttpServerPorts > 0) {
            this.portsMeta.on(0).tag("http").tag("query").tag("external").tag("state");
        }
        for (int i = 1; i < this.numHttpServerPorts; ++i) {
            this.portsMeta.on(i).tag("http").tag("external");
        }
        if (this.rpcServerEnabled()) {
            this.portsMeta.on(this.numHttpServerPorts + 0).tag("rpc").tag("messaging");
            this.portsMeta.on(this.numHttpServerPorts + 1).tag("rpc").tag("admin");
        }
    }

    private void reserveHttpPortsPrepended() {
        if (this.getHttp().getHttpServer() != null) {
            for (ConnectorFactory connectorFactory : this.getHttp().getHttpServer().getConnectorFactories()) {
                this.reservePortPrepended(this.getPort(connectorFactory, this.portOverrides));
            }
        }
    }

    private int getPort(ConnectorFactory connectorFactory, List<PortOverride> portOverrides) {
        ComponentId id = ComponentId.fromString((String)connectorFactory.getName());
        for (PortOverride override : portOverrides) {
            if (!override.serverId.matches(id)) continue;
            return override.port;
        }
        return connectorFactory.getListenPort();
    }

    private void initDefaultJettyConnector() {
        this.defaultHttpServer.addConnector(new ConnectorFactory("SearchServer", this.getSearchPort()));
    }

    private boolean hasDocproc() {
        return this.parent instanceof ContainerCluster && ((ContainerCluster)this.parent).getDocproc() != null;
    }

    @Override
    public String getServiceType() {
        if (this.myServiceType != null) {
            return this.myServiceType;
        }
        if (this.parent instanceof ContainerCluster) {
            ContainerCluster cluster = (ContainerCluster)this.parent;
            if (cluster.getSearch() != null && cluster.getDocproc() == null && cluster.getDocumentApi() == null) {
                this.myServiceType = "qrserver";
                return this.myServiceType;
            }
            if (cluster.getSearch() == null && cluster.getDocproc() != null) {
                this.myServiceType = "docprocservice";
                return this.myServiceType;
            }
        }
        this.myServiceType = super.getServiceType();
        return this.myServiceType;
    }

    public void setClusterName(String name) {
        this.clusterName = name;
    }

    @Override
    public int getWantedPort() {
        return this.getHttp() == null ? BASEPORT : 0;
    }

    @Override
    public boolean requiresWantedPort() {
        return this.getHttp() == null;
    }

    @Override
    public boolean requiresConsecutivePorts() {
        return false;
    }

    @Override
    public int getPortCount() {
        int httpPorts = this.getHttp() != null ? 0 : this.numHttpServerPorts + 2;
        int rpcPorts = this.rpcServerEnabled() ? 2 : 0;
        return httpPorts + rpcPorts;
    }

    public int getSearchPort() {
        if (this.getHttp() != null) {
            throw new AssertionError((Object)"getSearchPort must not be used when http section is present.");
        }
        return this.getRelativePort(0);
    }

    private int getRpcPort() {
        return this.rpcServerEnabled() ? this.getRelativePort(this.numHttpServerPorts + 1) : 0;
    }

    private int getMessagingPort() {
        return this.getRelativePort(this.numHttpServerPorts);
    }

    @Override
    public int getHealthPort() {
        Http http = this.getHttp();
        if (http != null) {
            if (http.getHttpServer() == null) {
                return -1;
            }
            return this.getRelativePort(0);
        }
        return this.httpServerEnabled() ? this.getSearchPort() : -1;
    }

    @Override
    public String getStartupCommand() {
        return "PRELOAD=" + this.getPreLoad() + " exec vespa-start-container-daemon " + this.getJvmOptions() + " ";
    }

    public void getConfig(QrConfig.Builder builder) {
        builder.rpc(new QrConfig.Rpc.Builder().enabled(this.rpcServerEnabled()).port(this.getRpcPort()).slobrokId(this.serviceSlobrokId())).filedistributor(this.filedistributorConfig());
        if (this.clusterName != null) {
            builder.discriminator(this.clusterName + "." + this.name);
        } else {
            builder.discriminator(this.name);
        }
    }

    @Override
    public String getJvmOptions() {
        String jvmArgs = super.getJvmOptions();
        return this.isHostedVespa && this.hasDocproc() ? ("".equals(jvmArgs) ? defaultHostedJVMArgs : "-XX:+UseOSErrorReporting -XX:+SuppressFatalErrorMessage " + jvmArgs) : jvmArgs;
    }

    public String getAssignedJvmOptions() {
        return super.getJvmOptions();
    }

    private String serviceSlobrokId() {
        return "vespa/service/" + this.getConfigId();
    }

    private QrConfig.Filedistributor.Builder filedistributorConfig() {
        QrConfig.Filedistributor.Builder builder = new QrConfig.Filedistributor.Builder();
        FileDistributionConfigProducer fileDistribution = this.getRoot().getFileDistributionConfigProducer();
        if (fileDistribution != null) {
            builder.configid(fileDistribution.getConfigProducer(this.getHost()).getConfigId());
        }
        return builder;
    }

    public void getConfig(ComponentsConfig.Builder builder) {
        builder.components.addAll(ComponentsConfigGenerator.generate(this.allEnabledComponents()));
    }

    private Collection<Component<?, ?>> allEnabledComponents() {
        ArrayList allComponents = new ArrayList();
        this.addAllEnabledComponents(allComponents, this);
        return Collections.unmodifiableCollection(allComponents);
    }

    private void addAllEnabledComponents(Collection<Component<?, ?>> allComponents, AbstractConfigProducer<?> current) {
        for (AbstractConfigProducer child : current.getChildren().values()) {
            if (!this.httpServerEnabled() && this.isHttpServer(child)) continue;
            if (child instanceof Component) {
                allComponents.add((Component)child);
            }
            this.addAllEnabledComponents(allComponents, child);
        }
    }

    private boolean isHttpServer(AbstractConfigProducer<?> component) {
        return component instanceof JettyHttpServer;
    }

    public final void getConfig(JdiscBindingsConfig.Builder builder) {
        builder.handlers(DiscBindingsConfigGenerator.generate(this.handlers.getComponents()));
    }

    public void getConfig(ContainerHttpConfig.Builder builder) {
        if (this.hostResponseHeaderKey.isPresent()) {
            builder.hostResponseHeaderKey(this.hostResponseHeaderKey.get());
        }
    }

    public void getConfig(ContainerMbusConfig.Builder builder) {
        builder.enabled(this.messageBusEnabled()).port(this.getMessagingPort());
    }

    @Override
    public HashMap<String, String> getDefaultMetricDimensions() {
        HashMap<String, String> dimensions = new HashMap<String, String>();
        if (this.clusterName != null) {
            dimensions.put("clustername", this.clusterName);
        }
        return dimensions;
    }

    private boolean messageBusEnabled() {
        return this.containerCluster().isPresent() && this.containerCluster().get().messageBusEnabled();
    }

    private boolean httpServerEnabled() {
        return this.containerCluster().isPresent() && this.containerCluster().get().httpServerEnabled();
    }

    private boolean rpcServerEnabled() {
        return this.containerCluster().isPresent() && this.containerCluster().get().rpcServerEnabled();
    }

    private Optional<ContainerCluster> containerCluster() {
        return this.parent instanceof ContainerCluster ? Optional.of((ContainerCluster)this.parent) : Optional.empty();
    }

    public static final class PortOverride {
        public final ComponentSpecification serverId;
        public final int port;

        public PortOverride(ComponentSpecification serverId, int port) {
            this.serverId = serverId;
            this.port = port;
        }
    }
}

