/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.clients;

import com.yahoo.component.ComponentId;
import com.yahoo.component.chain.dependencies.Dependencies;
import com.yahoo.component.chain.model.ChainSpecification;
import com.yahoo.component.chain.model.ChainedComponentModel;
import com.yahoo.container.bundle.BundleInstantiationSpecification;
import com.yahoo.osgi.provider.model.ComponentModel;
import com.yahoo.vespa.model.container.ContainerCluster;
import com.yahoo.vespa.model.container.component.Handler;
import com.yahoo.vespa.model.container.component.chain.ProcessingHandler;
import com.yahoo.vespa.model.container.search.ContainerSearch;
import com.yahoo.vespa.model.container.search.searchchain.SearchChain;
import com.yahoo.vespa.model.container.search.searchchain.SearchChains;
import com.yahoo.vespa.model.container.search.searchchain.Searcher;
import com.yahoo.vespaclient.config.FeederConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.TreeSet;

public class ContainerDocumentApi
implements FeederConfig.Producer {
    public static final String vespaClientBundleSpecification = "vespaclient-container-plugin";
    private final Options options;

    public ContainerDocumentApi(ContainerCluster cluster, Options options) {
        this.options = options;
        this.setupLegacySearchers(cluster);
        this.setupHandlers(cluster);
    }

    private void setupHandlers(ContainerCluster cluster) {
        cluster.addComponent(this.newVespaClientHandler("com.yahoo.feedhandler.VespaFeedHandler", "feed"));
        cluster.addComponent(this.newVespaClientHandler("com.yahoo.feedhandler.VespaFeedHandlerRemove", "remove"));
        cluster.addComponent(this.newVespaClientHandler("com.yahoo.feedhandler.VespaFeedHandlerRemoveLocation", "removelocation"));
        cluster.addComponent(this.newVespaClientHandler("com.yahoo.feedhandler.VespaFeedHandlerGet", "get"));
        cluster.addComponent(this.newVespaClientHandler("com.yahoo.feedhandler.VespaFeedHandlerVisit", "visit"));
        cluster.addComponent(this.newVespaClientHandler("com.yahoo.document.restapi.resource.RestApi", "document/v1/*"));
        cluster.addComponent(this.newVespaClientHandler("com.yahoo.feedhandler.VespaFeedHandlerCompatibility", "document"));
        cluster.addComponent(this.newVespaClientHandler("com.yahoo.feedhandler.VespaFeedHandlerStatus", "feedstatus"));
        cluster.addComponent(this.newVespaClientHandler("com.yahoo.vespa.http.server.FeedHandler", "reserved-for-internal-use/feedapi"));
    }

    private void setupLegacySearchers(ContainerCluster cluster) {
        TreeSet inherited = new TreeSet();
        SearchChain vespaGetChain = new SearchChain(new ChainSpecification(new ComponentId("vespaget"), new ChainSpecification.Inheritance(inherited, null), new ArrayList(), new TreeSet()));
        vespaGetChain.addInnerComponent(this.newVespaClientSearcher("com.yahoo.storage.searcher.GetSearcher"));
        SearchChain vespaVisitChain = new SearchChain(new ChainSpecification(new ComponentId("vespavisit"), new ChainSpecification.Inheritance(inherited, null), new ArrayList(), new TreeSet()));
        vespaVisitChain.addInnerComponent(this.newVespaClientSearcher("com.yahoo.storage.searcher.VisitSearcher"));
        SearchChains chains = cluster.getSearch() != null ? cluster.getSearchChains() : new SearchChains(cluster, "searchchain");
        chains.add(vespaGetChain);
        chains.add(vespaVisitChain);
        if (cluster.getSearch() == null) {
            ContainerSearch containerSearch = new ContainerSearch(cluster, chains, new ContainerSearch.Options());
            cluster.setSearch(containerSearch);
            ProcessingHandler<SearchChains> searchHandler = new ProcessingHandler<SearchChains>(chains, "com.yahoo.search.handler.SearchHandler");
            searchHandler.addServerBindings("http://*/search/*", "https://*/search/*");
            cluster.addComponent(searchHandler);
        }
    }

    private Handler newVespaClientHandler(String componentId, String bindingSuffix) {
        Handler handler = new Handler(new ComponentModel(BundleInstantiationSpecification.getFromStrings((String)componentId, null, (String)vespaClientBundleSpecification), ""));
        for (String rootBinding : this.options.bindings) {
            handler.addServerBindings(rootBinding + bindingSuffix, rootBinding + bindingSuffix + '/');
        }
        return handler;
    }

    private Searcher newVespaClientSearcher(String componentSpec) {
        return new Searcher<ChainedComponentModel>(new ChainedComponentModel(BundleInstantiationSpecification.getFromStrings((String)componentSpec, null, (String)vespaClientBundleSpecification), new Dependencies(null, null, null)));
    }

    public void getConfig(FeederConfig.Builder builder) {
        if (this.options.abortondocumenterror != null) {
            builder.abortondocumenterror(this.options.abortondocumenterror.booleanValue());
        }
        if (this.options.route != null) {
            builder.route(this.options.route);
        }
        if (this.options.maxpendingdocs != null) {
            builder.maxpendingdocs(this.options.maxpendingdocs.intValue());
        }
        if (this.options.maxpendingbytes != null) {
            builder.maxpendingbytes(this.options.maxpendingbytes.intValue());
        }
        if (this.options.retryenabled != null) {
            builder.retryenabled(this.options.retryenabled.booleanValue());
        }
        if (this.options.retrydelay != null) {
            builder.retrydelay(this.options.retrydelay.doubleValue());
        }
        if (this.options.timeout != null) {
            builder.timeout(this.options.timeout.doubleValue());
        }
        if (this.options.tracelevel != null) {
            builder.tracelevel(this.options.tracelevel.intValue());
        }
        if (this.options.mbusport != null) {
            builder.mbusport(this.options.mbusport.intValue());
        }
        if (this.options.docprocChain != null) {
            builder.docprocchain(this.options.docprocChain);
        }
    }

    public static final class Options {
        private final Collection<String> bindings;
        private final Boolean abortondocumenterror;
        private final String route;
        private final Integer maxpendingdocs;
        private final Integer maxpendingbytes;
        private final Boolean retryenabled;
        private final Double retrydelay;
        private final Double timeout;
        private final Integer tracelevel;
        private final Integer mbusport;
        private final String docprocChain;

        public Options(Collection<String> bindings, Boolean abortondocumenterror, String route, Integer maxpendingdocs, Integer maxpendingbytes, Boolean retryenabled, Double retrydelay, Double timeout, Integer tracelevel, Integer mbusport, String docprocChain) {
            this.bindings = Collections.unmodifiableCollection(bindings);
            this.abortondocumenterror = abortondocumenterror;
            this.route = route;
            this.maxpendingdocs = maxpendingdocs;
            this.maxpendingbytes = maxpendingbytes;
            this.retryenabled = retryenabled;
            this.retrydelay = retrydelay;
            this.timeout = timeout;
            this.tracelevel = tracelevel;
            this.mbusport = mbusport;
            this.docprocChain = docprocChain;
        }
    }
}

