/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.document.DataType;
import com.yahoo.document.NumericDataType;
import com.yahoo.document.ReferenceDataType;
import com.yahoo.searchdefinition.document.Attribute;
import com.yahoo.searchdefinition.document.Matching;
import com.yahoo.searchdefinition.document.SDField;
import com.yahoo.vespa.model.VespaModel;
import com.yahoo.vespa.model.application.validation.Validator;
import com.yahoo.vespa.model.search.AbstractSearchCluster;
import com.yahoo.vespa.model.search.SearchCluster;
import java.util.List;
import java.util.logging.Level;

public class StreamingValidator
extends Validator {
    @Override
    public void validate(VespaModel model, DeployState deployState) {
        List<AbstractSearchCluster> searchClusters = model.getSearchClusters();
        for (AbstractSearchCluster cluster : searchClusters) {
            if (!cluster.isStreaming()) continue;
            SearchCluster sc = (SearchCluster)cluster;
            StreamingValidator.warnStreamingAttributes(sc, deployState.getDeployLogger());
            StreamingValidator.warnStreamingGramMatching(sc, deployState.getDeployLogger());
            StreamingValidator.failStreamingDocumentReferences(sc);
        }
    }

    private static void warnStreamingGramMatching(SearchCluster sc, DeployLogger logger) {
        if (sc.getSdConfig() != null) {
            for (SDField sd : sc.getSdConfig().getSearch().allConcreteFields()) {
                if (!sd.getMatching().getType().equals((Object)Matching.Type.GRAM)) continue;
                logger.log(Level.WARNING, "For streaming search cluster '" + sc.getClusterName() + "', SD field '" + sd.getName() + "': n-gram matching is not supported for streaming search.");
            }
        }
    }

    private static void warnStreamingAttributes(SearchCluster sc, DeployLogger logger) {
        if (sc.getSdConfig() != null) {
            for (SDField sd : sc.getSdConfig().getSearch().allConcreteFields()) {
                if (!sd.doesAttributing()) continue;
                StreamingValidator.warnStreamingAttribute(sc, sd, logger);
            }
        }
    }

    private static void warnStreamingAttribute(SearchCluster sc, SDField sd, DeployLogger logger) {
        if (sd.getDataType() instanceof NumericDataType) {
            return;
        }
        logger.log(Level.WARNING, "For streaming search cluster '" + sc.getClusterName() + "', SD field '" + sd.getName() + "': 'attribute' has same match semantics as 'index'.");
    }

    private static void failStreamingDocumentReferences(SearchCluster sc) {
        for (Attribute attribute : sc.getSdConfig().getAttributeFields().attributes()) {
            DataType dataType = attribute.getDataType();
            if (!(dataType instanceof ReferenceDataType)) continue;
            String errorMessage = String.format("For streaming search cluster '%s': Attribute '%s' has type '%s'. Document references and imported fields are not allowed in streaming search.", sc.getClusterName(), attribute.getName(), dataType.getName());
            throw new IllegalArgumentException(errorMessage);
        }
    }
}

