/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.admin;

import com.yahoo.cloud.config.LogforwarderConfig;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.vespa.model.AbstractService;

public class LogForwarder
extends AbstractService
implements LogforwarderConfig.Producer {
    private final Config config;

    public LogForwarder(AbstractConfigProducer parent, Config config) {
        super(parent, "logforwarder");
        this.config = config;
        this.setProp("clustertype", "hosts");
        this.setProp("clustername", "admin");
    }

    public static Config cfg() {
        return new Config(null, null, null);
    }

    @Override
    public int getPortCount() {
        return 0;
    }

    @Override
    public String getStartupCommand() {
        return "exec $ROOT/bin/vespa-logforwarder-start -c " + this.getConfigId();
    }

    public void getConfig(LogforwarderConfig.Builder builder) {
        builder.deploymentServer(this.config.deploymentServer);
        builder.clientName(this.config.clientName);
        if (this.config.splunkHome != null) {
            builder.splunkHome(this.config.splunkHome);
        }
    }

    public static class Config {
        public final String deploymentServer;
        public final String clientName;
        public final String splunkHome;

        private Config(String ds, String cn, String sh) {
            this.deploymentServer = ds;
            this.clientName = cn;
            this.splunkHome = sh;
        }

        public Config withDeploymentServer(String ds) {
            return new Config(ds, this.clientName, this.splunkHome);
        }

        public Config withClientName(String cn) {
            return new Config(this.deploymentServer, cn, this.splunkHome);
        }

        public Config withSplunkHome(String sh) {
            return new Config(this.deploymentServer, this.clientName, sh);
        }
    }
}

