/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.document.ArrayDataType;
import com.yahoo.document.CollectionDataType;
import com.yahoo.document.DataType;
import com.yahoo.document.PrimitiveDataType;
import com.yahoo.document.WeightedSetDataType;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.document.SDField;
import com.yahoo.searchdefinition.document.Stemming;
import com.yahoo.searchdefinition.processing.Processor;
import com.yahoo.vespa.model.container.search.QueryProfiles;
import java.util.Arrays;
import java.util.List;

public class UriHack
extends Processor {
    private static final List<String> URL_SUFFIX = Arrays.asList("scheme", "host", "port", "path", "query", "fragment", "hostname");

    public UriHack(Search search, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(search, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        for (SDField field : this.search.allConcreteFields()) {
            if (!field.doesIndexing()) continue;
            DataType fieldType = field.getDataType();
            if (fieldType instanceof CollectionDataType) {
                fieldType = ((CollectionDataType)fieldType).getNestedType();
            }
            if (fieldType != DataType.URI) continue;
            this.processField(this.search, field);
        }
    }

    private void processField(Search search, SDField uriField) {
        String uriName = uriField.getName();
        uriField.setStemming(Stemming.NONE);
        PrimitiveDataType generatedType = DataType.STRING;
        if (uriField.getDataType() instanceof ArrayDataType) {
            generatedType = new ArrayDataType((DataType)DataType.STRING);
        } else if (uriField.getDataType() instanceof WeightedSetDataType) {
            WeightedSetDataType wdt = (WeightedSetDataType)uriField.getDataType();
            generatedType = new WeightedSetDataType((DataType)DataType.STRING, wdt.createIfNonExistent(), wdt.removeIfZero());
        }
        for (String suffix : URL_SUFFIX) {
            String partName = uriName + "." + suffix;
            SDField partField = new SDField(partName, (DataType)generatedType, true);
            partField.setIndexStructureField(uriField.doesIndexing());
            partField.setRankType(uriField.getRankType());
            partField.setStemming(Stemming.NONE);
            partField.getNormalizing().inferLowercase();
            if (uriField.getIndex(suffix) != null) {
                partField.addIndex(uriField.getIndex(suffix));
            }
            search.addExtraField(partField);
            search.fieldSets().addBuiltInFieldSetItem("[internal]", partField.getName());
        }
    }
}

