/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.document.ImmutableImportedSDField;
import com.yahoo.searchdefinition.document.ImmutableSDField;
import com.yahoo.searchdefinition.processing.Processor;
import com.yahoo.vespa.documentmodel.SummaryField;
import com.yahoo.vespa.documentmodel.SummaryTransform;
import com.yahoo.vespa.model.container.search.QueryProfiles;
import java.util.stream.Stream;

public class AddAttributeTransformToSummaryOfImportedFields
extends Processor {
    public AddAttributeTransformToSummaryOfImportedFields(Search search, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(search, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        this.search.allImportedFields().flatMap(this::getSummaryFieldsForImportedField).forEach(AddAttributeTransformToSummaryOfImportedFields::setAttributeTransform);
        this.search.importedFields().map(fields -> fields.complexFields().values().stream()).orElse(Stream.empty()).map(ImmutableImportedSDField::new).flatMap(this::getSummaryFieldsForImportedField).forEach(AddAttributeTransformToSummaryOfImportedFields::setAttributeCombinerTransform);
    }

    private Stream<SummaryField> getSummaryFieldsForImportedField(ImmutableSDField importedField) {
        return this.search.getSummaryFields(importedField).values().stream();
    }

    private static void setAttributeTransform(SummaryField summaryField) {
        if (summaryField.getTransform() == SummaryTransform.NONE) {
            summaryField.setTransform(SummaryTransform.ATTRIBUTE);
        }
    }

    private static void setAttributeCombinerTransform(SummaryField summaryField) {
        summaryField.setTransform(SummaryTransform.ATTRIBUTECOMBINER);
    }
}

