/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.builder.xml.dom;

import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.text.XML;
import com.yahoo.vespa.config.content.spooler.SpoolerConfig;
import com.yahoo.vespa.defaults.Defaults;
import com.yahoo.vespa.model.SimpleConfigProducer;
import com.yahoo.vespa.model.builder.xml.dom.VespaDomBuilder;
import com.yahoo.vespa.model.clients.Clients;
import com.yahoo.vespa.model.clients.VespaSpoolMaster;
import com.yahoo.vespa.model.clients.VespaSpooler;
import com.yahoo.vespa.model.clients.VespaSpoolerProducer;
import com.yahoo.vespa.model.clients.VespaSpoolerService;
import com.yahoo.vespaclient.config.FeederConfig;
import java.io.Serializable;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DomV20ClientsBuilder {
    private final Clients clients;

    DomV20ClientsBuilder(Clients clients, String version) {
        if (!version.equals("2.0")) {
            throw new IllegalArgumentException("Version '" + version + "' of 'clients' not supported.");
        }
        this.clients = clients;
    }

    public void build(Element spec) {
        int i;
        NodeList children = spec.getElementsByTagName("spoolers");
        for (i = 0; i < children.getLength(); ++i) {
            this.createSpoolers(this.clients.getConfigProducer(), (Element)children.item(i), this.clients);
        }
        children = spec.getElementsByTagName("load-types");
        for (i = 0; i < children.getLength(); ++i) {
            this.createLoadTypes((Element)children.item(i), this.clients);
        }
    }

    private void createLoadTypes(Element element, Clients clients) {
        for (Element e : XML.getChildren((Element)element, (String)"type")) {
            String priority = e.getAttribute("default-priority");
            clients.getLoadTypes().addType(e.getAttribute("name"), priority.length() > 0 ? priority : null);
        }
    }

    private void createSpoolers(AbstractConfigProducer pcp, Element element, Clients clients) {
        String jvmArgs = null;
        if (element.hasAttribute("jvmargs")) {
            jvmArgs = element.getAttribute("jvmargs");
        }
        SimpleConfigProducer spoolerCfg = (SimpleConfigProducer)new VespaDomBuilder.DomSimpleConfigProducerBuilder(element.getNodeName()).build(pcp, element);
        Element spoolersFeederOptions = this.findFeederOptions(element);
        this.createSpoolMasters(spoolerCfg, element);
        for (Element e : XML.getChildren((Element)element, (String)"spooler")) {
            String configId = e.getAttribute("id").trim();
            FeederConfig.Builder feederConfig = this.getFeederConfig(spoolersFeederOptions, e);
            SpoolerConfig.Builder spoolConfig = this.getSpoolConfig(e);
            if (configId.length() == 0) {
                int index = clients.getVespaSpoolers().size();
                VespaSpoolerService spoolerService = (VespaSpoolerService)new VespaSpoolerServiceBuilder(index, new VespaSpooler(feederConfig, spoolConfig)).build(spoolerCfg, e);
                if ("".equals(spoolerService.getJvmArgs()) && jvmArgs != null) {
                    spoolerService.setJvmArgs(jvmArgs);
                }
                spoolerService.setProp("index", String.valueOf(index));
                clients.getVespaSpoolers().add(spoolerService);
                continue;
            }
            new VespaSpoolerProducerBuilder(configId, new VespaSpooler(feederConfig, spoolConfig)).build(spoolerCfg, e);
        }
    }

    private void createSpoolMasters(SimpleConfigProducer producer, Element element) {
        int i = 0;
        for (Element e : XML.getChildren((Element)element, (String)"spoolmaster")) {
            new VespaSpoolMasterBuilder(i++).build(producer, e);
        }
    }

    private SpoolerConfig.Builder getSpoolConfig(Element conf) {
        NodeList children;
        SpoolerConfig.Builder builder = new SpoolerConfig.Builder();
        if (conf.getAttributes().getNamedItem("directory") != null) {
            builder.directory(Defaults.getDefaults().underVespaHome(conf.getAttributes().getNamedItem("directory").getNodeValue()));
        }
        if (conf.getAttributes().getNamedItem("keepsuccess") != null) {
            builder.keepsuccess(this.getBooleanFromAttribute(conf, "keepsuccess").booleanValue());
        }
        if (conf.getAttributes().getNamedItem("maxfailuresize") != null) {
            builder.maxfailuresize(this.getIntegerFromAttribute(conf, "maxfailuresize").intValue());
        }
        if (conf.getAttributes().getNamedItem("maxfatalfailuresize") != null) {
            builder.maxfatalfailuresize(this.getIntegerFromAttribute(conf, "maxfatalfailuresize").intValue());
        }
        if (conf.getAttributes().getNamedItem("threads") != null) {
            builder.threads(this.getIntegerFromAttribute(conf, "threads").intValue());
        }
        if (conf.getAttributes().getNamedItem("maxretries") != null) {
            builder.maxretries(this.getIntegerFromAttribute(conf, "maxretries").intValue());
        }
        if ((children = conf.getElementsByTagName("parsers")).getLength() == 1) {
            children = ((Element)children.item(0)).getElementsByTagName("parser");
        }
        for (int i = 0; i < children.getLength(); ++i) {
            Element e = (Element)children.item(i);
            String type = e.getAttributes().getNamedItem("type").getNodeValue();
            NodeList params = e.getElementsByTagName("parameter");
            SpoolerConfig.Parsers.Builder parserBuilder = new SpoolerConfig.Parsers.Builder();
            parserBuilder.classname(type);
            if (params.getLength() > 0) {
                ArrayList<SpoolerConfig.Parsers.Parameters.Builder> parametersBuilders = new ArrayList<SpoolerConfig.Parsers.Parameters.Builder>();
                for (int j = 0; j < params.getLength(); ++j) {
                    SpoolerConfig.Parsers.Parameters.Builder parametersBuilder = new SpoolerConfig.Parsers.Parameters.Builder();
                    Element p = (Element)params.item(j);
                    parametersBuilder.key(this.getStringFromAttribute(p, "key"));
                    parametersBuilder.value(this.getStringFromAttribute(p, "value"));
                    parametersBuilders.add(parametersBuilder);
                }
                parserBuilder.parameters(parametersBuilders);
            }
            builder.parsers.add(parserBuilder);
        }
        return builder;
    }

    Boolean getBooleanFromAttribute(Element e, String attributeName) {
        return Boolean.parseBoolean(e.getAttributes().getNamedItem(attributeName).getNodeValue());
    }

    Integer getIntegerFromAttribute(Element e, String attributeName) {
        return Integer.parseInt(e.getAttributes().getNamedItem(attributeName).getNodeValue());
    }

    String getStringFromAttribute(Element e, String attributeName) {
        return e.getAttributes().getNamedItem(attributeName).getNodeValue();
    }

    private FeederConfig.Builder getFeederConfig(Element gatewaysFeederOptions, Element e) {
        FeederOptionsParser foParser = new FeederOptionsParser();
        if (gatewaysFeederOptions != null) {
            foParser.parseFeederOptions(gatewaysFeederOptions).getFeederConfig();
        }
        foParser.parseFeederOptions(e);
        return foParser.getFeederConfig();
    }

    private Element findFeederOptions(Element element) {
        for (Element child : XML.getChildren((Element)element)) {
            if (!child.getNodeName().equals("feederoptions")) continue;
            return child;
        }
        return null;
    }

    private class FeederOptionsParser
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Boolean abortondocumenterror = null;
        private String route = null;
        private Integer maxpendingdocs = null;
        private Integer maxpendingbytes = null;
        private Boolean retryenabled = null;
        private Double retrydelay = null;
        private Double timeout = null;
        private Integer tracelevel = null;
        private Integer mbusport = null;
        private String docprocChain = null;

        public FeederOptionsParser parseFeederOptions(Element conf) {
            for (Node node : XML.getChildren((Element)conf)) {
                String nodename = node.getNodeName();
                Node firstchild = node.getFirstChild();
                String childval = firstchild != null ? firstchild.getNodeValue() : null;
                switch (nodename) {
                    case "abortondocumenterror": {
                        this.abortondocumenterror = Boolean.valueOf(childval);
                        break;
                    }
                    case "maxpendingdocs": {
                        this.maxpendingdocs = Integer.valueOf(childval);
                        break;
                    }
                    case "maxpendingbytes": {
                        this.maxpendingbytes = Integer.valueOf(childval);
                        break;
                    }
                    case "retryenabled": {
                        this.retryenabled = Boolean.valueOf(childval);
                        break;
                    }
                    case "retrydelay": {
                        this.retrydelay = Double.valueOf(childval);
                        break;
                    }
                    case "timeout": {
                        this.timeout = Double.valueOf(childval);
                        break;
                    }
                    case "route": {
                        this.route = childval;
                        break;
                    }
                    case "tracelevel": {
                        this.tracelevel = Integer.valueOf(childval);
                        break;
                    }
                    case "mbusport": {
                        this.mbusport = Integer.valueOf(childval);
                        break;
                    }
                    case "docprocchain": {
                        this.docprocChain = childval;
                    }
                }
            }
            return this;
        }

        public FeederConfig.Builder getFeederConfig() {
            FeederConfig.Builder builder = new FeederConfig.Builder();
            if (this.abortondocumenterror != null) {
                builder.abortondocumenterror(this.abortondocumenterror.booleanValue());
            }
            if (this.route != null && this.route.length() > 0) {
                builder.route(this.route);
            }
            if (this.maxpendingdocs != null) {
                builder.maxpendingdocs(this.maxpendingdocs.intValue());
            }
            if (this.maxpendingbytes != null) {
                builder.maxpendingbytes(this.maxpendingbytes.intValue());
            }
            if (this.retryenabled != null) {
                builder.retryenabled(this.retryenabled.booleanValue());
            }
            if (this.retrydelay != null) {
                builder.retrydelay(this.retrydelay.doubleValue());
            }
            if (this.timeout != null) {
                builder.timeout(this.timeout.doubleValue());
            }
            if (this.tracelevel != null) {
                builder.tracelevel(this.tracelevel.intValue());
            }
            if (this.mbusport != null) {
                builder.mbusport(this.mbusport.intValue());
            }
            if (this.docprocChain != null && this.docprocChain.length() > 0) {
                builder.docprocchain(this.docprocChain);
            }
            return builder;
        }
    }

    private static class VespaSpoolMasterBuilder
    extends VespaDomBuilder.DomConfigProducerBuilder<VespaSpoolMaster> {
        int index;

        public VespaSpoolMasterBuilder(int index) {
            this.index = index;
        }

        @Override
        protected VespaSpoolMaster doBuild(AbstractConfigProducer parent, Element spec) {
            return new VespaSpoolMaster(parent, this.index);
        }
    }

    private static class VespaSpoolerProducerBuilder
    extends VespaDomBuilder.DomConfigProducerBuilder<VespaSpoolerProducer> {
        private String name = null;
        private VespaSpooler spooler;

        public VespaSpoolerProducerBuilder(String name, VespaSpooler spooler) {
            this.name = name;
            this.spooler = spooler;
        }

        @Override
        protected VespaSpoolerProducer doBuild(AbstractConfigProducer parent, Element producerSpec) {
            return new VespaSpoolerProducer(parent, this.name, this.spooler);
        }
    }

    private static class VespaSpoolerServiceBuilder
    extends VespaDomBuilder.DomConfigProducerBuilder<VespaSpoolerService> {
        private int index;
        private VespaSpooler spoolerConfig;

        public VespaSpoolerServiceBuilder(int index, VespaSpooler spoolerConfig) {
            this.index = index;
            this.spoolerConfig = spoolerConfig;
        }

        @Override
        protected VespaSpoolerService doBuild(AbstractConfigProducer parent, Element spec) {
            return new VespaSpoolerService(parent, this.index, this.spoolerConfig);
        }
    }
}

