/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.admin;

import com.yahoo.cloud.config.ZookeepersConfig;
import com.yahoo.collections.CollectionUtil;
import com.yahoo.config.model.api.ConfigServerSpec;
import com.yahoo.vespa.model.admin.Configserver;
import java.util.ArrayList;
import java.util.List;

public class ZooKeepersConfigProvider
implements ZookeepersConfig.Producer {
    public static final int zkPort = Integer.getInteger("zk_port", 2181);
    private final List<Configserver> configServers;

    public ZooKeepersConfigProvider(List<Configserver> configServers) {
        if (configServers == null) {
            configServers = new ArrayList<Configserver>();
        }
        this.configServers = configServers;
    }

    public List<String> getZooKeepers() {
        ArrayList<String> servers = new ArrayList<String>();
        for (Configserver server : this.configServers) {
            ConfigServerSpec serverSpec = server.getConfigServerSpec();
            servers.add(serverSpec.getHostName() + ":" + serverSpec.getZooKeeperPort());
        }
        return servers;
    }

    public String getZooKeepersConnectionSpec() {
        return CollectionUtil.mkString(this.getZooKeepers(), (String)",");
    }

    public void getConfig(ZookeepersConfig.Builder builder) {
        builder.zookeeperserverlist(this.getZooKeepersConnectionSpec());
    }
}

