/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.derived;

import com.yahoo.config.ConfigInstance;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.model.application.provider.BaseDeployLogger;
import com.yahoo.document.DocumenttypesConfig;
import com.yahoo.document.config.DocumentmanagerConfig;
import com.yahoo.io.IOUtils;
import com.yahoo.protect.Validator;
import com.yahoo.search.query.profile.QueryProfileRegistry;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.derived.AttributeFields;
import com.yahoo.searchdefinition.derived.ImportedFields;
import com.yahoo.searchdefinition.derived.IndexInfo;
import com.yahoo.searchdefinition.derived.IndexSchema;
import com.yahoo.searchdefinition.derived.IndexingScript;
import com.yahoo.searchdefinition.derived.Juniperrc;
import com.yahoo.searchdefinition.derived.RankProfileList;
import com.yahoo.searchdefinition.derived.Summaries;
import com.yahoo.searchdefinition.derived.SummaryMap;
import com.yahoo.searchdefinition.derived.VsmFields;
import com.yahoo.searchdefinition.derived.VsmSummary;
import com.yahoo.searchdefinition.derived.validation.Validation;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;

public class DerivedConfiguration {
    private Search search;
    private Summaries summaries;
    private SummaryMap summaryMap;
    private Juniperrc juniperrc;
    private AttributeFields attributeFields;
    private RankProfileList rankProfileList;
    private IndexingScript indexingScript;
    private IndexInfo indexInfo;
    private VsmFields streamingFields;
    private VsmSummary streamingSummary;
    private IndexSchema indexSchema;
    private ImportedFields importedFields;

    public DerivedConfiguration(Search search, RankProfileRegistry rankProfileRegistry, QueryProfileRegistry queryProfiles) {
        this(search, null, (DeployLogger)new BaseDeployLogger(), rankProfileRegistry, queryProfiles);
    }

    public DerivedConfiguration(Search search, List<Search> abstractSearchList, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfileRegistry queryProfiles) {
        Validator.ensureNotNull((String)"Search definition", (Object)search);
        if (!search.isProcessed()) {
            throw new IllegalArgumentException("Search '" + search.getName() + "' not processed.");
        }
        this.search = search;
        if (!search.isDocumentsOnly()) {
            this.streamingFields = new VsmFields(search);
            this.streamingSummary = new VsmSummary(search);
        }
        if (abstractSearchList != null) {
            for (Search abstractSearch : abstractSearchList) {
                if (abstractSearch.isProcessed()) continue;
                throw new IllegalArgumentException("Search '" + search.getName() + "' not processed.");
            }
        }
        if (!search.isDocumentsOnly()) {
            this.attributeFields = new AttributeFields(search);
            this.summaries = new Summaries(search, deployLogger);
            this.summaryMap = new SummaryMap(search, this.summaries);
            this.juniperrc = new Juniperrc(search);
            this.rankProfileList = new RankProfileList(search, this.attributeFields, rankProfileRegistry, queryProfiles);
            this.indexingScript = new IndexingScript(search);
            this.indexInfo = new IndexInfo(search);
            this.indexSchema = new IndexSchema(search);
            this.importedFields = new ImportedFields(search);
        }
        Validation.validate(this, search);
    }

    public void export(String toDirectory) throws IOException {
        if (!this.search.isDocumentsOnly()) {
            this.summaries.export(toDirectory);
            this.summaryMap.export(toDirectory);
            this.juniperrc.export(toDirectory);
            this.attributeFields.export(toDirectory);
            this.streamingFields.export(toDirectory);
            this.streamingSummary.export(toDirectory);
            this.indexSchema.export(toDirectory);
            this.rankProfileList.export(toDirectory);
            this.indexingScript.export(toDirectory);
            this.indexInfo.export(toDirectory);
            this.importedFields.export(toDirectory);
        }
    }

    public static void exportDocuments(DocumentmanagerConfig.Builder documentManagerCfg, String toDirectory) throws IOException {
        DerivedConfiguration.exportCfg((ConfigInstance)new DocumentmanagerConfig(documentManagerCfg), toDirectory + "/documentmanager.cfg");
    }

    public static void exportDocuments(DocumenttypesConfig.Builder documentTypesCfg, String toDirectory) throws IOException {
        DerivedConfiguration.exportCfg((ConfigInstance)new DocumenttypesConfig(documentTypesCfg), toDirectory + "/documenttypes.cfg");
    }

    private static void exportCfg(ConfigInstance instance, String fileName) throws IOException {
        BufferedWriter writer = null;
        try {
            writer = IOUtils.createWriter((String)fileName, (boolean)false);
            if (writer != null) {
                writer.write(instance.toString());
                writer.write("\n");
            }
        }
        finally {
            if (writer != null) {
                IOUtils.closeWriter((Writer)writer);
            }
        }
    }

    public Summaries getSummaries() {
        return this.summaries;
    }

    public AttributeFields getAttributeFields() {
        return this.attributeFields;
    }

    public IndexingScript getIndexingScript() {
        return this.indexingScript;
    }

    public IndexInfo getIndexInfo() {
        return this.indexInfo;
    }

    public void setIndexingScript(IndexingScript script) {
        this.indexingScript = script;
    }

    public Search getSearch() {
        return this.search;
    }

    public RankProfileList getRankProfileList() {
        return this.rankProfileList;
    }

    public VsmSummary getVsmSummary() {
        return this.streamingSummary;
    }

    public VsmFields getVsmFields() {
        return this.streamingFields;
    }

    public IndexSchema getIndexSchema() {
        return this.indexSchema;
    }

    public Juniperrc getJuniperrc() {
        return this.juniperrc;
    }

    public SummaryMap getSummaryMap() {
        return this.summaryMap;
    }

    public ImportedFields getImportedFields() {
        return this.importedFields;
    }
}

