/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.xml;

import com.yahoo.text.XML;
import com.yahoo.vespa.model.clients.ContainerDocumentApi;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import org.w3c.dom.Element;

public class DocumentApiOptionsBuilder {
    private static final Logger log = Logger.getLogger(DocumentApiOptionsBuilder.class.getName());
    private static final String[] DEFAULT_BINDINGS = new String[]{"http://*/", "https://*/"};

    public static ContainerDocumentApi.Options build(Element spec) {
        return new ContainerDocumentApi.Options(DocumentApiOptionsBuilder.getBindings(spec), DocumentApiOptionsBuilder.getAbortOnDocumentError(spec), DocumentApiOptionsBuilder.getRoute(spec), DocumentApiOptionsBuilder.getMaxPendingDocs(spec), DocumentApiOptionsBuilder.getMaxPendingBytes(spec), DocumentApiOptionsBuilder.getRetryEnabled(spec), DocumentApiOptionsBuilder.getRetryDelay(spec), DocumentApiOptionsBuilder.getTimeout(spec), DocumentApiOptionsBuilder.getTracelevel(spec), DocumentApiOptionsBuilder.getMbusPort(spec), DocumentApiOptionsBuilder.getDocprocChain(spec));
    }

    private static List<String> getBindings(Element spec) {
        List bindingElems = XML.getChildren((Element)spec, (String)"binding");
        if (bindingElems.isEmpty()) {
            return Arrays.asList(DEFAULT_BINDINGS);
        }
        ArrayList<String> bindings = new ArrayList<String>();
        for (Element e : bindingElems) {
            String binding = DocumentApiOptionsBuilder.getBinding(e);
            bindings.add(binding);
        }
        return bindings;
    }

    private static String getBinding(Element e) {
        String binding = XML.getValue((Element)e);
        if (!binding.endsWith("/")) {
            log.warning("Adding a trailing '/' to the document-api binding: " + binding + " -> " + binding + "/");
            binding = binding + "/";
        }
        return binding;
    }

    private static String getCleanValue(Element spec, String name) {
        Element elem = XML.getChild((Element)spec, (String)name);
        if (elem == null) {
            return null;
        }
        String value = elem.getFirstChild().getNodeValue();
        if (value == null) {
            return null;
        }
        return (value = value.trim()).isEmpty() ? null : value;
    }

    private static String getDocprocChain(Element spec) {
        return DocumentApiOptionsBuilder.getCleanValue(spec, "docprocchain");
    }

    private static Integer getMbusPort(Element spec) {
        String value = DocumentApiOptionsBuilder.getCleanValue(spec, "mbusport");
        return value == null ? null : Integer.valueOf(Integer.parseInt(value));
    }

    private static Integer getTracelevel(Element spec) {
        String value = DocumentApiOptionsBuilder.getCleanValue(spec, "tracelevel");
        return value == null ? null : Integer.valueOf(Integer.parseInt(value));
    }

    private static Double getTimeout(Element spec) {
        String value = DocumentApiOptionsBuilder.getCleanValue(spec, "timeout");
        return value == null ? null : Double.valueOf(Double.parseDouble(value));
    }

    private static Double getRetryDelay(Element spec) {
        String value = DocumentApiOptionsBuilder.getCleanValue(spec, "retrydelay");
        return value == null ? null : Double.valueOf(Double.parseDouble(value));
    }

    private static Boolean getRetryEnabled(Element spec) {
        String value = DocumentApiOptionsBuilder.getCleanValue(spec, "retryenabled");
        return value == null ? null : Boolean.valueOf(Boolean.parseBoolean(value));
    }

    private static Integer getMaxPendingBytes(Element spec) {
        String value = DocumentApiOptionsBuilder.getCleanValue(spec, "maxpendingbytes");
        return value == null ? null : Integer.valueOf(Integer.parseInt(value));
    }

    private static Integer getMaxPendingDocs(Element spec) {
        String value = DocumentApiOptionsBuilder.getCleanValue(spec, "maxpendingdocs");
        return value == null ? null : Integer.valueOf(Integer.parseInt(value));
    }

    private static String getRoute(Element spec) {
        return DocumentApiOptionsBuilder.getCleanValue(spec, "route");
    }

    private static Boolean getAbortOnDocumentError(Element spec) {
        String value = DocumentApiOptionsBuilder.getCleanValue(spec, "abortondocumenterror");
        return value == null ? null : Boolean.valueOf(Boolean.parseBoolean(value));
    }
}

