/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation.change.search;

import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.document.Matching;
import com.yahoo.searchdefinition.document.NormalizeLevel;
import com.yahoo.searchdefinition.document.SDField;
import com.yahoo.searchdefinition.document.Stemming;
import com.yahoo.vespa.documentmodel.SummaryField;
import com.yahoo.vespa.documentmodel.SummaryTransform;
import com.yahoo.vespa.model.application.validation.change.search.ChangeMessageBuilder;

public class IndexingScriptChangeMessageBuilder {
    private final Search currentSearch;
    private final SDField currentField;
    private final Search nextSearch;
    private final SDField nextField;

    public IndexingScriptChangeMessageBuilder(Search currentSearch, SDField currentField, Search nextSearch, SDField nextField) {
        this.currentSearch = currentSearch;
        this.currentField = currentField;
        this.nextSearch = nextSearch;
        this.nextField = nextField;
    }

    public void populate(ChangeMessageBuilder builder) {
        this.checkIndexing(builder);
        this.checkMatching(builder);
        this.checkStemming(builder);
        this.checkNormalizing(builder);
        this.checkSummaryTransform(builder);
    }

    private void checkIndexing(ChangeMessageBuilder builder) {
        if (this.currentField.doesIndexing() != this.nextField.doesIndexing()) {
            String change = this.nextField.doesIndexing() ? "add" : "remove";
            builder.addChange(change + " index aspect");
        }
    }

    private void checkMatching(ChangeMessageBuilder builder) {
        Matching nextMatching;
        Matching currentMatching = this.currentField.getMatching();
        if (!currentMatching.equals(nextMatching = this.nextField.getMatching())) {
            builder.addChange("matching", IndexingScriptChangeMessageBuilder.toString(currentMatching), IndexingScriptChangeMessageBuilder.toString(nextMatching));
        }
    }

    private void checkStemming(ChangeMessageBuilder builder) {
        Stemming nextStemming;
        Stemming currentStemming = this.currentField.getStemming(this.currentSearch);
        if (!currentStemming.equals((Object)(nextStemming = this.nextField.getStemming(this.nextSearch)))) {
            builder.addChange("stemming", currentStemming.getName(), nextStemming.getName());
        }
    }

    private void checkNormalizing(ChangeMessageBuilder builder) {
        NormalizeLevel.Level nextLevel;
        NormalizeLevel.Level currentLevel = this.currentField.getNormalizing().getLevel();
        if (!currentLevel.equals((Object)(nextLevel = this.nextField.getNormalizing().getLevel()))) {
            builder.addChange("normalizing", currentLevel.toString(), nextLevel.toString());
        }
    }

    private void checkSummaryTransform(ChangeMessageBuilder builder) {
        for (SummaryField nextSummaryField : this.nextField.getSummaryFields()) {
            String fieldName = nextSummaryField.getName();
            SummaryField currentSummaryField = this.currentField.getSummaryField(fieldName);
            if (currentSummaryField == null) continue;
            SummaryTransform currentTransform = currentSummaryField.getTransform();
            SummaryTransform nextTransform = nextSummaryField.getTransform();
            if (currentSummaryField.getTransform().equals((Object)nextSummaryField.getTransform())) continue;
            builder.addChange("summary field '" + fieldName + "' transform", currentTransform.getName(), nextTransform.getName());
        }
    }

    private static String toString(Matching matching) {
        Matching.Type type = matching.getType();
        String retval = type.getName();
        if (type.equals((Object)Matching.Type.GRAM)) {
            retval = retval + " (size " + matching.getGramSize() + ")";
        }
        return retval;
    }
}

