/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.derived;

import com.yahoo.config.ConfigInstance;
import com.yahoo.config.InnerNode;
import com.yahoo.document.Field;
import com.yahoo.io.IOUtils;
import com.yahoo.searchdefinition.Index;
import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.derived.Exportable;
import com.yahoo.searchdefinition.document.ImmutableSDField;
import com.yahoo.searchdefinition.document.SDDocumentType;
import com.yahoo.searchdefinition.document.SDField;
import com.yahoo.text.StringUtilities;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.List;

public abstract class Derived
implements Exportable {
    private String name;

    public String getName() {
        return this.name;
    }

    protected final void setName(String name) {
        this.name = name;
    }

    protected void derive(Search search) {
        this.setName(search.getName());
        this.derive(search.getDocument(), search);
        for (Index index : search.getExplicitIndices()) {
            this.derive(index, search);
        }
        for (SDField field : search.allExtraFields()) {
            this.derive(field, search);
        }
        search.allImportedFields().forEach(importedField -> this.derive((ImmutableSDField)importedField, search));
    }

    protected void derive(SDDocumentType document, Search search) {
        for (Field field : document.fieldSet()) {
            SDField sdField = (SDField)field;
            if (sdField.isExtraField()) continue;
            this.derive(sdField, search);
        }
    }

    protected void derive(ImmutableSDField field, Search search) {
    }

    protected void derive(Index index, Search search) {
    }

    protected abstract String getDerivedName();

    protected String getIndex(int number, boolean labels) {
        return labels ? this.getName() : String.valueOf(number);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void export(String toDirectory) throws IOException {
        BufferedWriter writer = null;
        try {
            String fileName = this.getDerivedName() + ".cfg";
            if (toDirectory != null) {
                writer = IOUtils.createWriter((String)(toDirectory + "/" + fileName), (boolean)false);
            }
            try {
                this.exportBuilderConfig(writer);
            }
            catch (IllegalArgumentException | ReflectiveOperationException | SecurityException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            if (writer != null) {
                IOUtils.closeWriter(writer);
            }
        }
    }

    private void exportBuilderConfig(Writer writer) throws ReflectiveOperationException, SecurityException, IllegalArgumentException, IOException {
        for (Class<?> intf : this.getClass().getInterfaces()) {
            if (!ConfigInstance.Producer.class.isAssignableFrom(intf)) continue;
            Class<?> configClass = intf.getEnclosingClass();
            String builderClassName = configClass.getCanonicalName() + "$Builder";
            Class<?> builderClass = Class.forName(builderClassName);
            ConfigInstance.Builder builder = (ConfigInstance.Builder)builderClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Method getConfig = this.getClass().getMethod("getConfig", builderClass);
            getConfig.invoke((Object)this, builder);
            ConfigInstance inst = (ConfigInstance)configClass.getConstructor(builderClass).newInstance(builder);
            List payloadL = ConfigInstance.serialize((InnerNode)inst);
            String payload = StringUtilities.implodeMultiline((List)payloadL);
            writer.write(payload);
        }
    }

    @Override
    public String getFileName() {
        return this.getDerivedName() + ".cfg";
    }
}

