/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition;

import com.yahoo.searchdefinition.Index;
import com.yahoo.searchdefinition.RankProfile;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.document.SDField;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public class DefaultRankProfile
extends RankProfile {
    public DefaultRankProfile(Search search, RankProfileRegistry rankProfileRegistry) {
        super("default", search, rankProfileRegistry);
    }

    @Override
    public void setInherited(String inheritedName) {
    }

    @Override
    public String getInheritedName() {
        return null;
    }

    @Override
    public RankProfile.RankSetting getRankSetting(String fieldOrIndex, RankProfile.RankSetting.Type type) {
        RankProfile.RankSetting setting = super.getRankSetting(fieldOrIndex, type);
        if (setting != null) {
            return setting;
        }
        SDField field = this.getSearch().getConcreteField(fieldOrIndex);
        if (field != null && (setting = this.toRankSetting(field, type)) != null) {
            return setting;
        }
        Index index = this.getSearch().getIndex(fieldOrIndex);
        if (index != null && (setting = this.toRankSetting(index, type)) != null) {
            return setting;
        }
        return null;
    }

    private RankProfile.RankSetting toRankSetting(SDField field, RankProfile.RankSetting.Type type) {
        if (type.equals((Object)RankProfile.RankSetting.Type.WEIGHT) && field.getWeight() > 0 && field.getWeight() != 100) {
            return new RankProfile.RankSetting(field.getName(), type, field.getWeight());
        }
        if (type.equals((Object)RankProfile.RankSetting.Type.RANKTYPE)) {
            return new RankProfile.RankSetting(field.getName(), type, (Object)field.getRankType());
        }
        if (type.equals((Object)RankProfile.RankSetting.Type.LITERALBOOST) && field.getLiteralBoost() > 0) {
            return new RankProfile.RankSetting(field.getName(), type, field.getLiteralBoost());
        }
        if (type.equals((Object)RankProfile.RankSetting.Type.PREFERBITVECTOR) && field.getRanking().isFilter()) {
            return new RankProfile.RankSetting(field.getName(), type, true);
        }
        return null;
    }

    private RankProfile.RankSetting toRankSetting(Index index, RankProfile.RankSetting.Type type) {
        return null;
    }

    @Override
    public Set<RankProfile.RankSetting> rankSettings() {
        LinkedHashSet<RankProfile.RankSetting> settings = new LinkedHashSet<RankProfile.RankSetting>(20);
        settings.addAll(this.rankSettings);
        for (SDField field : this.getSearch().allConcreteFields()) {
            this.addSetting(field, RankProfile.RankSetting.Type.WEIGHT, settings);
            this.addSetting(field, RankProfile.RankSetting.Type.RANKTYPE, settings);
            this.addSetting(field, RankProfile.RankSetting.Type.LITERALBOOST, settings);
            this.addSetting(field, RankProfile.RankSetting.Type.PREFERBITVECTOR, settings);
        }
        for (Index index : this.getSearch().getExplicitIndices()) {
            this.addSetting(index, RankProfile.RankSetting.Type.PREFERBITVECTOR, settings);
        }
        return settings;
    }

    private void addSetting(SDField field, RankProfile.RankSetting.Type type, Set<RankProfile.RankSetting> settings) {
        if (type.isIndexLevel()) {
            this.addIndexSettings(field, type, settings);
        } else {
            RankProfile.RankSetting setting = this.toRankSetting(field, type);
            if (setting == null) {
                return;
            }
            settings.add(setting);
        }
    }

    private void addIndexSettings(SDField field, RankProfile.RankSetting.Type type, Set<RankProfile.RankSetting> settings) {
        Iterator<String> i = field.getFieldNameAsIterator();
        while (i.hasNext()) {
            String indexName = i.next();
            Index explicitIndex = field.getIndex(indexName);
            if (!type.equals((Object)RankProfile.RankSetting.Type.PREFERBITVECTOR) || !field.getRanking().isFilter()) continue;
            settings.add(new RankProfile.RankSetting(indexName, type, true));
        }
    }

    private void addSetting(Index index, RankProfile.RankSetting.Type type, Set<RankProfile.RankSetting> settings) {
        RankProfile.RankSetting setting = this.toRankSetting(index, type);
        if (setting == null) {
            return;
        }
        settings.add(setting);
    }
}

