/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.document.Matching;
import com.yahoo.searchdefinition.document.Ranking;
import com.yahoo.searchdefinition.document.SDField;
import com.yahoo.searchdefinition.processing.Processor;
import com.yahoo.vespa.model.container.search.QueryProfiles;

public class ValidateFieldWithIndexSettingsCreatesIndex
extends Processor {
    public ValidateFieldWithIndexSettingsCreatesIndex(Search search, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(search, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate) {
        if (!validate) {
            return;
        }
        Matching defaultMatching = new Matching();
        Ranking defaultRanking = new Ranking();
        for (SDField field : this.search.allConcreteFields()) {
            if (field.doesIndexing() || field.doesAttributing()) continue;
            if (!field.getRanking().equals(defaultRanking)) {
                this.fail(this.search, field, "Fields which are not creating an index or attribute can not contain rank settings.");
            }
            if (field.getMatching().equals(defaultMatching)) continue;
            this.fail(this.search, field, "Fields which are not creating an index or attribute can not contain match settings.");
        }
    }
}

