/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.searchdefinition.RankProfile;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.document.RankType;
import com.yahoo.searchdefinition.document.SDField;
import com.yahoo.searchdefinition.processing.Processor;
import com.yahoo.vespa.model.container.search.QueryProfiles;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;

public class FilterFieldNames
extends Processor {
    public FilterFieldNames(Search search, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(search, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate) {
        for (SDField f : this.search.allConcreteFields()) {
            if (!f.getRanking().isFilter()) continue;
            this.filterField(f.getName());
        }
        for (RankProfile profile : this.rankProfileRegistry.localRankProfiles(this.search)) {
            LinkedHashSet<String> filterFields = new LinkedHashSet<String>();
            this.findFilterFields(this.search, profile, filterFields);
            for (String fieldName : filterFields) {
                profile.filterFields().add(fieldName);
                profile.addRankSetting(fieldName, RankProfile.RankSetting.Type.RANKTYPE, (Object)RankType.EMPTY);
            }
        }
    }

    private void filterField(String f) {
        for (RankProfile rp : this.rankProfileRegistry.localRankProfiles(this.search)) {
            rp.filterFields().add(f);
        }
    }

    private void findFilterFields(Search search, RankProfile profile, Set<String> filterFields) {
        Iterator<RankProfile.RankSetting> itr = profile.declaredRankSettingIterator();
        while (itr.hasNext()) {
            RankProfile.RankSetting setting = itr.next();
            if (!setting.getType().equals((Object)RankProfile.RankSetting.Type.PREFERBITVECTOR) || !((Boolean)setting.getValue()).booleanValue()) continue;
            String fieldName = setting.getFieldName();
            if (search.getConcreteField(fieldName) != null) {
                if (profile.filterFields().contains(fieldName)) continue;
                filterFields.add(fieldName);
                continue;
            }
            this.deployLogger.log(Level.WARNING, "For rank profile '" + profile.getName() + "': Cannot apply rank filter setting to unexisting field '" + fieldName + "'");
        }
    }
}

