/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.document;

import com.yahoo.document.ArrayDataType;
import com.yahoo.document.DataType;
import com.yahoo.document.Field;
import com.yahoo.document.MapDataType;
import com.yahoo.document.PositionDataType;
import com.yahoo.document.StructDataType;
import com.yahoo.document.TemporaryStructuredDataType;
import com.yahoo.searchdefinition.document.ImmutableSDField;
import com.yahoo.searchdefinition.document.SDDocumentType;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;

public class ComplexAttributeFieldUtils {
    public static boolean isSupportedComplexField(ImmutableSDField field, SDDocumentType docType) {
        return ComplexAttributeFieldUtils.isArrayOfSimpleStruct(field, docType) || ComplexAttributeFieldUtils.isMapOfSimpleStruct(field, docType) || ComplexAttributeFieldUtils.isMapOfPrimitiveType(field);
    }

    public static boolean isSupportedComplexField(DataType fieldType) {
        return ComplexAttributeFieldUtils.isArrayOfSimpleStruct(fieldType) || ComplexAttributeFieldUtils.isMapOfSimpleStruct(fieldType) || ComplexAttributeFieldUtils.isMapOfPrimitiveType(fieldType);
    }

    public static boolean isArrayOfSimpleStruct(ImmutableSDField field, SDDocumentType docType) {
        return ComplexAttributeFieldUtils.isArrayOfSimpleStruct(field.getDataType(), Optional.of(docType));
    }

    public static boolean isArrayOfSimpleStruct(DataType fieldType) {
        return ComplexAttributeFieldUtils.isArrayOfSimpleStruct(fieldType, Optional.empty());
    }

    private static boolean isArrayOfSimpleStruct(DataType fieldType, Optional<SDDocumentType> docType) {
        if (fieldType instanceof ArrayDataType) {
            ArrayDataType arrayType = (ArrayDataType)fieldType;
            return ComplexAttributeFieldUtils.isSimpleStruct(arrayType.getNestedType(), docType);
        }
        return false;
    }

    public static boolean isMapOfSimpleStruct(ImmutableSDField field, SDDocumentType docType) {
        return ComplexAttributeFieldUtils.isMapOfSimpleStruct(field.getDataType(), Optional.of(docType));
    }

    public static boolean isMapOfSimpleStruct(DataType fieldType) {
        return ComplexAttributeFieldUtils.isMapOfSimpleStruct(fieldType, Optional.empty());
    }

    private static boolean isMapOfSimpleStruct(DataType fieldType, Optional<SDDocumentType> docType) {
        if (fieldType instanceof MapDataType) {
            MapDataType mapType = (MapDataType)fieldType;
            return ComplexAttributeFieldUtils.isPrimitiveType(mapType.getKeyType()) && ComplexAttributeFieldUtils.isSimpleStruct(mapType.getValueType(), docType);
        }
        return false;
    }

    public static boolean isMapOfPrimitiveType(ImmutableSDField field) {
        return ComplexAttributeFieldUtils.isMapOfPrimitiveType(field.getDataType());
    }

    public static boolean isMapOfPrimitiveType(DataType fieldType) {
        if (fieldType instanceof MapDataType) {
            MapDataType mapType = (MapDataType)fieldType;
            return ComplexAttributeFieldUtils.isPrimitiveType(mapType.getKeyType()) && ComplexAttributeFieldUtils.isPrimitiveType(mapType.getValueType());
        }
        return false;
    }

    private static boolean isSimpleStruct(DataType type, Optional<SDDocumentType> docType) {
        if (type instanceof StructDataType && !type.equals((Object)PositionDataType.INSTANCE)) {
            StructDataType structType = (StructDataType)type;
            Collection<Field> structFields = ComplexAttributeFieldUtils.getStructFields(structType, docType);
            if (structFields.isEmpty()) {
                return false;
            }
            for (Field innerField : structFields) {
                if (ComplexAttributeFieldUtils.isPrimitiveType(innerField.getDataType())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static Collection<Field> getStructFields(StructDataType structType, Optional<SDDocumentType> docType) {
        if (docType.isPresent() && structType instanceof TemporaryStructuredDataType) {
            SDDocumentType realStructType = docType.get().getOwnedType(structType.getName());
            if (structType != null) {
                return realStructType.getDocumentType().getFields();
            }
            return Collections.emptyList();
        }
        return structType.getFields();
    }

    private static boolean isPrimitiveType(DataType dataType) {
        return dataType.equals((Object)DataType.BYTE) || dataType.equals((Object)DataType.INT) || dataType.equals((Object)DataType.LONG) || dataType.equals((Object)DataType.FLOAT) || dataType.equals((Object)DataType.DOUBLE) || dataType.equals((Object)DataType.STRING);
    }

    public static boolean isComplexFieldWithOnlyStructFieldAttributes(ImmutableSDField field, SDDocumentType docType) {
        if (ComplexAttributeFieldUtils.isArrayOfSimpleStruct(field, docType)) {
            return ComplexAttributeFieldUtils.hasOnlyStructFieldAttributes(field);
        }
        if (ComplexAttributeFieldUtils.isMapOfSimpleStruct(field, docType)) {
            return ComplexAttributeFieldUtils.hasSingleAttribute(field.getStructField("key")) && ComplexAttributeFieldUtils.hasOnlyStructFieldAttributes(field.getStructField("value"));
        }
        if (ComplexAttributeFieldUtils.isMapOfPrimitiveType(field)) {
            return ComplexAttributeFieldUtils.hasSingleAttribute(field.getStructField("key")) && ComplexAttributeFieldUtils.hasSingleAttribute(field.getStructField("value"));
        }
        return false;
    }

    private static boolean hasOnlyStructFieldAttributes(ImmutableSDField field) {
        for (ImmutableSDField immutableSDField : field.getStructFields()) {
            if (ComplexAttributeFieldUtils.hasSingleAttribute(immutableSDField)) continue;
            return false;
        }
        return true;
    }

    private static boolean hasSingleAttribute(ImmutableSDField field) {
        if (field.getAttributes().size() != 1) {
            return false;
        }
        return field.getAttributes().get(field.getName()) != null;
    }
}

