/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model.provision;

import com.yahoo.collections.ListMap;
import com.yahoo.collections.Pair;
import com.yahoo.config.model.api.HostProvisioner;
import com.yahoo.config.model.provision.Host;
import com.yahoo.config.model.provision.Hosts;
import com.yahoo.config.provision.Capacity;
import com.yahoo.config.provision.ClusterMembership;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.config.provision.HostSpec;
import com.yahoo.config.provision.ProvisionLogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class InMemoryProvisioner
implements HostProvisioner {
    private final boolean failOnOutOfCapacity;
    private final Set<String> retiredHostNames;
    private final ListMap<String, Host> freeNodes = new ListMap();
    private final Map<String, HostSpec> legacyMapping = new LinkedHashMap<String, HostSpec>();
    private final Map<ClusterSpec, List<HostSpec>> allocations = new LinkedHashMap<ClusterSpec, List<HostSpec>>();
    private final Map<Pair<ClusterSpec.Type, ClusterSpec.Id>, Integer> nextIndexInCluster = new HashMap<Pair<ClusterSpec.Type, ClusterSpec.Id>, Integer>();
    private final int startIndexForClusters;

    public InMemoryProvisioner(int nodeCount) {
        this(Collections.singletonMap("default", InMemoryProvisioner.createHostInstances(nodeCount)), true, 0, new String[0]);
    }

    public InMemoryProvisioner(boolean failOnOutOfCapacity, String ... hosts) {
        this(Collections.singletonMap("default", InMemoryProvisioner.toHostInstances(hosts)), failOnOutOfCapacity, 0, new String[0]);
    }

    public InMemoryProvisioner(Hosts hosts, boolean failOnOutOfCapacity, String ... retiredHostNames) {
        this(Collections.singletonMap("default", hosts.asCollection()), failOnOutOfCapacity, 0, retiredHostNames);
    }

    public InMemoryProvisioner(Hosts hosts, boolean failOnOutOfCapacity, int startIndexForClusters, String ... retiredHostNames) {
        this(Collections.singletonMap("default", hosts.asCollection()), failOnOutOfCapacity, startIndexForClusters, retiredHostNames);
    }

    public InMemoryProvisioner(Map<String, Collection<Host>> hosts, boolean failOnOutOfCapacity, int startIndexForClusters, String ... retiredHostNames) {
        this.failOnOutOfCapacity = failOnOutOfCapacity;
        for (Map.Entry<String, Collection<Host>> hostsOfFlavor : hosts.entrySet()) {
            for (Host host : hostsOfFlavor.getValue()) {
                this.freeNodes.put((Object)hostsOfFlavor.getKey(), (Object)host);
            }
        }
        this.retiredHostNames = new HashSet<String>(Arrays.asList(retiredHostNames));
        this.startIndexForClusters = startIndexForClusters;
    }

    private static Collection<Host> toHostInstances(String[] hostnames) {
        ArrayList<Host> hosts = new ArrayList<Host>();
        for (String hostname : hostnames) {
            hosts.add(new Host(hostname));
        }
        return hosts;
    }

    private static Collection<Host> createHostInstances(int hostCount) {
        ArrayList<Host> hosts = new ArrayList<Host>();
        for (int i = 1; i <= hostCount; ++i) {
            hosts.add(new Host("host" + i));
        }
        return hosts;
    }

    public HostSpec allocateHost(String alias) {
        if (this.legacyMapping.containsKey(alias)) {
            return this.legacyMapping.get(alias);
        }
        List defaultHosts = this.freeNodes.get((Object)"default");
        if (defaultHosts.isEmpty()) {
            throw new IllegalArgumentException("No more hosts of default flavor available");
        }
        Host newHost = (Host)this.freeNodes.removeValue((Object)"default", 0);
        HostSpec hostSpec = new HostSpec(newHost.hostname(), newHost.aliases(), newHost.flavor(), Optional.empty(), newHost.version());
        this.legacyMapping.put(alias, hostSpec);
        return hostSpec;
    }

    public List<HostSpec> prepare(ClusterSpec cluster, Capacity requestedCapacity, int groups, ProvisionLogger logger) {
        int capacity;
        if (cluster.group().isPresent() && groups > 1) {
            throw new IllegalArgumentException("Cannot both be specifying a group and ask for groups to be created");
        }
        if (requestedCapacity.nodeCount() % groups != 0) {
            throw new IllegalArgumentException("Requested " + requestedCapacity.nodeCount() + " nodes in " + groups + " groups, but the node count is not divisible into this number of groups");
        }
        int n = capacity = this.failOnOutOfCapacity || requestedCapacity.isRequired() ? requestedCapacity.nodeCount() : Math.min(requestedCapacity.nodeCount(), this.freeNodes.get((Object)"default").size() + this.totalAllocatedTo(cluster));
        if (groups > capacity) {
            groups = capacity;
        }
        String flavor = requestedCapacity.flavor().orElse("default");
        ArrayList<HostSpec> allocation = new ArrayList<HostSpec>();
        if (groups == 1) {
            allocation.addAll(this.allocateHostGroup(cluster.with(Optional.of(ClusterSpec.Group.from((int)0))), flavor, capacity, this.startIndexForClusters));
        } else {
            for (int i = 0; i < groups; ++i) {
                allocation.addAll(this.allocateHostGroup(cluster.with(Optional.of(ClusterSpec.Group.from((int)i))), flavor, capacity / groups, allocation.size()));
            }
        }
        ListIterator<HostSpec> i = allocation.listIterator();
        while (i.hasNext()) {
            HostSpec host = (HostSpec)i.next();
            if (!this.retiredHostNames.contains(host.hostname())) continue;
            i.set(this.retire(host));
        }
        return allocation;
    }

    private HostSpec retire(HostSpec host) {
        return new HostSpec(host.hostname(), host.aliases(), host.flavor(), Optional.of(((ClusterMembership)host.membership().get()).retire()), host.version());
    }

    private List<HostSpec> allocateHostGroup(ClusterSpec clusterGroup, String flavor, int nodesInGroup, int startIndex) {
        List allocation = this.allocations.getOrDefault(clusterGroup, new ArrayList());
        this.allocations.put(clusterGroup, allocation);
        int nextIndex = this.nextIndexInCluster.getOrDefault(new Pair((Object)clusterGroup.type(), (Object)clusterGroup.id()), startIndex);
        while (allocation.size() < nodesInGroup) {
            if (this.freeNodes.get((Object)flavor).isEmpty()) {
                throw new IllegalArgumentException("Insufficient capacity of flavor '" + flavor + "'");
            }
            Host newHost = (Host)this.freeNodes.removeValue((Object)flavor, 0);
            ClusterMembership membership = ClusterMembership.from((ClusterSpec)clusterGroup, (int)nextIndex++);
            allocation.add(new HostSpec(newHost.hostname(), newHost.aliases(), newHost.flavor(), Optional.of(membership), newHost.version()));
        }
        this.nextIndexInCluster.put((Pair<ClusterSpec.Type, ClusterSpec.Id>)new Pair((Object)clusterGroup.type(), (Object)clusterGroup.id()), nextIndex);
        while (allocation.size() > nodesInGroup) {
            allocation.remove(0);
        }
        return allocation;
    }

    private int totalAllocatedTo(ClusterSpec cluster) {
        int count = 0;
        for (Map.Entry<ClusterSpec, List<HostSpec>> allocation : this.allocations.entrySet()) {
            if (!allocation.getKey().type().equals((Object)cluster.type()) || !allocation.getKey().id().equals((Object)cluster.id())) continue;
            count += allocation.getValue().size();
        }
        return count;
    }
}

