/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.document;

import com.yahoo.document.ArrayDataType;
import com.yahoo.document.DataType;
import com.yahoo.document.Field;
import com.yahoo.document.MapDataType;
import com.yahoo.document.PositionDataType;
import com.yahoo.document.StructDataType;
import com.yahoo.searchdefinition.document.ImmutableSDField;

public class ComplexAttributeFieldUtils {
    public static boolean isArrayOfSimpleStruct(ImmutableSDField field) {
        DataType fieldType = field.getDataType();
        if (fieldType instanceof ArrayDataType) {
            ArrayDataType arrayType = (ArrayDataType)fieldType;
            return ComplexAttributeFieldUtils.isSimpleStruct(arrayType.getNestedType());
        }
        return false;
    }

    public static boolean isMapOfSimpleStruct(ImmutableSDField field) {
        DataType fieldType = field.getDataType();
        if (fieldType instanceof MapDataType) {
            MapDataType mapType = (MapDataType)fieldType;
            return ComplexAttributeFieldUtils.isPrimitiveType(mapType.getKeyType()) && ComplexAttributeFieldUtils.isSimpleStruct(mapType.getValueType());
        }
        return false;
    }

    public static boolean isMapOfPrimitiveType(ImmutableSDField field) {
        DataType fieldType = field.getDataType();
        if (fieldType instanceof MapDataType) {
            MapDataType mapType = (MapDataType)fieldType;
            return ComplexAttributeFieldUtils.isPrimitiveType(mapType.getKeyType()) && ComplexAttributeFieldUtils.isPrimitiveType(mapType.getValueType());
        }
        return false;
    }

    private static boolean isSimpleStruct(DataType type) {
        if (type instanceof StructDataType && !type.equals((Object)PositionDataType.INSTANCE)) {
            StructDataType structType = (StructDataType)type;
            for (Field innerField : structType.getFields()) {
                if (ComplexAttributeFieldUtils.isPrimitiveType(innerField.getDataType())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean isPrimitiveType(DataType dataType) {
        return dataType.equals((Object)DataType.BYTE) || dataType.equals((Object)DataType.INT) || dataType.equals((Object)DataType.LONG) || dataType.equals((Object)DataType.FLOAT) || dataType.equals((Object)DataType.DOUBLE) || dataType.equals((Object)DataType.STRING);
    }

    public static boolean isComplexFieldWithOnlyStructFieldAttributes(ImmutableSDField field) {
        if (ComplexAttributeFieldUtils.isArrayOfSimpleStruct(field)) {
            return ComplexAttributeFieldUtils.hasOnlyStructFieldAttributes(field);
        }
        if (ComplexAttributeFieldUtils.isMapOfSimpleStruct(field)) {
            return ComplexAttributeFieldUtils.hasSingleAttribute(field.getStructField("key")) && ComplexAttributeFieldUtils.hasOnlyStructFieldAttributes(field.getStructField("value"));
        }
        if (ComplexAttributeFieldUtils.isMapOfPrimitiveType(field)) {
            return ComplexAttributeFieldUtils.hasSingleAttribute(field.getStructField("key")) && ComplexAttributeFieldUtils.hasSingleAttribute(field.getStructField("value"));
        }
        return false;
    }

    private static boolean hasOnlyStructFieldAttributes(ImmutableSDField field) {
        for (ImmutableSDField immutableSDField : field.getStructFields()) {
            if (ComplexAttributeFieldUtils.hasSingleAttribute(immutableSDField)) continue;
            return false;
        }
        return true;
    }

    private static boolean hasSingleAttribute(ImmutableSDField field) {
        if (field.getAttributes().size() != 1) {
            return false;
        }
        return field.getAttributes().get(field.getName()) != null;
    }
}

