/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.configserver;

import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.cloud.config.ZookeeperServerConfig;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.config.provision.Environment;
import com.yahoo.config.provision.RegionName;
import com.yahoo.config.provision.SystemName;
import com.yahoo.config.provision.Zone;
import com.yahoo.container.StatisticsConfig;
import com.yahoo.container.jdisc.config.HealthMonitorConfig;
import com.yahoo.jdisc.metrics.yamasconsumer.cloud.ScoreBoardConfig;
import com.yahoo.net.HostName;
import com.yahoo.vespa.defaults.Defaults;
import com.yahoo.vespa.model.container.ContainerCluster;
import com.yahoo.vespa.model.container.configserver.option.CloudConfigOptions;
import java.util.Optional;

public class ConfigserverCluster
extends AbstractConfigProducer
implements ZookeeperServerConfig.Producer,
ConfigserverConfig.Producer,
ScoreBoardConfig.Producer,
StatisticsConfig.Producer,
HealthMonitorConfig.Producer {
    private final CloudConfigOptions options;
    private ContainerCluster containerCluster;

    public ConfigserverCluster(AbstractConfigProducer parent, String subId, CloudConfigOptions options) {
        super(parent, subId);
        this.options = options;
    }

    public void setContainerCluster(ContainerCluster containerCluster) {
        this.containerCluster = containerCluster;
        Environment environment = this.options.environment().isPresent() ? Environment.from((String)this.options.environment().get()) : Environment.defaultEnvironment();
        RegionName region = this.options.region().isPresent() ? RegionName.from((String)this.options.region().get()) : RegionName.defaultName();
        SystemName system = this.options.system().isPresent() ? SystemName.from((String)this.options.system().get()) : SystemName.defaultSystem();
        containerCluster.setZone(new Zone(system, environment, region));
    }

    public void getConfig(ZookeeperServerConfig.Builder builder) {
        String myhostname = HostName.getLocalhost();
        int myid = 0;
        int i = 0;
        for (CloudConfigOptions.ConfigServer server : this.getConfigServers()) {
            if (server.hostName.equals(myhostname)) {
                myid = i;
            }
            builder.server(this.getZkServer(server, i));
            ++i;
        }
        builder.myid(myid);
        if (this.options.zookeeperClientPort().isPresent()) {
            builder.clientPort(this.options.zookeeperClientPort().get().intValue());
        }
    }

    public void getConfig(ConfigserverConfig.Builder builder) {
        for (String pluginDir : this.getConfigModelPluginDirs()) {
            builder.configModelPluginDir(pluginDir);
        }
        if (this.options.sessionLifeTimeSecs().isPresent()) {
            builder.sessionLifetime(this.options.sessionLifeTimeSecs().get().longValue());
        }
        if (this.options.zookeeperBarrierTimeout().isPresent()) {
            builder.zookeeper(new ConfigserverConfig.Zookeeper.Builder().barrierTimeout(this.options.zookeeperBarrierTimeout().get().longValue()));
        }
        if (this.options.rpcPort().isPresent()) {
            builder.rpcport(this.options.rpcPort().get().intValue());
        }
        if (this.options.multiTenant().isPresent()) {
            builder.multitenant(this.options.multiTenant().get().booleanValue());
        }
        if (this.options.payloadCompressionType().isPresent()) {
            builder.payloadCompressionType(ConfigserverConfig.PayloadCompressionType.Enum.valueOf((String)this.options.payloadCompressionType().get()));
        }
        for (CloudConfigOptions.ConfigServer server : this.getConfigServers()) {
            ConfigserverConfig.Zookeeperserver.Builder zkBuilder = new ConfigserverConfig.Zookeeperserver.Builder();
            zkBuilder.hostname(server.hostName);
            if (this.options.zookeeperClientPort().isPresent()) {
                zkBuilder.port(this.options.zookeeperClientPort().get().intValue());
            }
            builder.zookeeperserver(zkBuilder);
        }
        if (this.options.environment().isPresent()) {
            builder.environment(this.options.environment().get());
        }
        if (this.options.region().isPresent()) {
            builder.region(this.options.region().get());
        }
        if (this.options.system().isPresent()) {
            builder.environment(this.options.system().get());
        }
        if (this.options.defaultFlavor().isPresent()) {
            builder.defaultFlavor(this.options.defaultFlavor().get());
        }
        if (this.options.defaultAdminFlavor().isPresent()) {
            builder.defaultAdminFlavor(this.options.defaultAdminFlavor().get());
        }
        if (this.options.defaultContainerFlavor().isPresent()) {
            builder.defaultContainerFlavor(this.options.defaultContainerFlavor().get());
        }
        if (this.options.defaultContentFlavor().isPresent()) {
            builder.defaultContentFlavor(this.options.defaultContentFlavor().get());
        }
        builder.serverId(HostName.getLocalhost());
        if (!this.containerCluster.getHttp().getHttpServer().getConnectorFactories().isEmpty()) {
            builder.httpport(this.containerCluster.getHttp().getHttpServer().getConnectorFactories().get(0).getListenPort());
        }
        if (this.options.useVespaVersionInRequest().isPresent()) {
            builder.useVespaVersionInRequest(this.options.useVespaVersionInRequest().get().booleanValue());
        } else if (this.options.multiTenant().isPresent()) {
            builder.useVespaVersionInRequest(this.options.multiTenant().get().booleanValue());
        }
        if (this.options.hostedVespa().isPresent()) {
            builder.hostedVespa(this.options.hostedVespa().get().booleanValue());
        }
        if (this.options.numParallelTenantLoaders().isPresent()) {
            builder.numParallelTenantLoaders(this.options.numParallelTenantLoaders().get().intValue());
        }
        if (this.options.loadBalancerAddress().isPresent()) {
            builder.loadBalancerAddress(this.options.loadBalancerAddress().get());
        }
    }

    private String[] getConfigModelPluginDirs() {
        if (this.options.configModelPluginDirs().length > 0) {
            return this.options.configModelPluginDirs();
        }
        return new String[]{Defaults.getDefaults().underVespaHome("lib/jars/config-models")};
    }

    private CloudConfigOptions.ConfigServer[] getConfigServers() {
        if (this.options.allConfigServers().length > 0) {
            return this.options.allConfigServers();
        }
        return new CloudConfigOptions.ConfigServer[]{new CloudConfigOptions.ConfigServer(HostName.getLocalhost(), Optional.empty())};
    }

    private ZookeeperServerConfig.Server.Builder getZkServer(CloudConfigOptions.ConfigServer server, int id) {
        ZookeeperServerConfig.Server.Builder builder = new ZookeeperServerConfig.Server.Builder();
        if (this.options.zookeeperElectionPort().isPresent()) {
            builder.electionPort(this.options.zookeeperElectionPort().get().intValue());
        }
        if (this.options.zookeeperQuorumPort().isPresent()) {
            builder.quorumPort(this.options.zookeeperQuorumPort().get().intValue());
        }
        builder.hostname(server.hostName);
        builder.id(id);
        return builder;
    }

    public void getConfig(ScoreBoardConfig.Builder builder) {
        builder.applicationName("configserver");
        builder.flushTime(60);
        builder.step(60);
    }

    public void getConfig(StatisticsConfig.Builder builder) {
        builder.collectionintervalsec(60.0);
        builder.loggingintervalsec(60.0);
    }

    public void getConfig(HealthMonitorConfig.Builder builder) {
        builder.snapshot_interval(60.0);
    }
}

