/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.docproc;

import com.yahoo.component.ComponentId;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.container.jdisc.config.SessionConfig;
import com.yahoo.vespa.model.container.ContainerCluster;
import com.yahoo.vespa.model.container.component.Component;
import com.yahoo.vespa.model.container.component.chain.Chains;
import com.yahoo.vespa.model.container.component.chain.ProcessingHandler;
import com.yahoo.vespa.model.container.docproc.DocprocChain;
import com.yahoo.vespa.model.container.docproc.MbusClient;

public class DocprocChains
extends Chains<DocprocChain> {
    private final ProcessingHandler<DocprocChains> docprocHandler = new ProcessingHandler<DocprocChains>(this, "com.yahoo.docproc.jdisc.DocumentProcessingHandler");

    public DocprocChains(AbstractConfigProducer parent, String subId) {
        super(parent, subId);
        this.addComponent(this.docprocHandler);
    }

    public ProcessingHandler<DocprocChains> getDocprocHandler() {
        return this.docprocHandler;
    }

    private void addComponent(Component component) {
        if (!(this.getParent() instanceof ContainerCluster)) {
            return;
        }
        ((ContainerCluster)this.getParent()).addComponent(component);
    }

    public void addServersAndClientsForChains() {
        if (this.getParent() instanceof ContainerCluster) {
            for (DocprocChain chain : this.getChainGroup().getComponents()) {
                this.addServerAndClientForChain((ContainerCluster)this.getParent(), chain);
            }
        }
    }

    private void addServerAndClientForChain(ContainerCluster cluster, DocprocChain docprocChain) {
        this.docprocHandler.addServerBindings("mbus://*/" + docprocChain.getSessionName());
        cluster.addMbusServer(ComponentId.fromString((String)docprocChain.getSessionName()));
        MbusClient client = new MbusClient(docprocChain.getSessionName(), SessionConfig.Type.INTERMEDIATE);
        client.addClientBindings("mbus://*/" + client.getSessionName());
        this.addComponent(client);
    }
}

