/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model;

import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.ConfigurationRuntimeException;
import com.yahoo.config.codegen.CNode;
import com.yahoo.config.codegen.ConfiggenUtil;
import com.yahoo.config.codegen.InnerCNode;
import com.yahoo.config.codegen.LeafCNode;
import com.yahoo.vespa.config.ConfigDefinitionKey;
import com.yahoo.vespa.config.ConfigKey;
import com.yahoo.vespa.config.buildergen.ConfigDefinition;
import com.yahoo.vespa.model.VespaModel;
import com.yahoo.yolean.Exceptions;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

class InstanceResolver {
    private static final Logger log = Logger.getLogger(InstanceResolver.class.getName());

    InstanceResolver() {
    }

    static ConfigInstance resolveToInstance(ConfigKey<?> key, ConfigBuilder builder, InnerCNode targetDef) {
        ConfigDefinitionKey defKey = new ConfigDefinitionKey(key);
        try {
            if (targetDef != null) {
                InstanceResolver.applyDef(builder, targetDef);
            }
            Class<? extends ConfigInstance> clazz = InstanceResolver.getConfigClass(defKey, builder.getClass().getClassLoader());
            return clazz.getConstructor(builder.getClass()).newInstance(builder);
        }
        catch (Exception e) {
            throw new ConfigurationRuntimeException((Throwable)e);
        }
    }

    static ConfigBuilder resolveToBuilder(ConfigKey<?> key, VespaModel model, ConfigDefinition targetDef) {
        if (model == null) {
            return null;
        }
        ConfigDefinitionKey defKey = new ConfigDefinitionKey(key);
        ConfigInstance.Builder builder = model.createBuilder(defKey, targetDef);
        model.getConfig(builder, key.getConfigId());
        return builder;
    }

    static void applyDef(ConfigBuilder builder, InnerCNode targetDef) throws Exception {
        for (Map.Entry e : targetDef.children().entrySet()) {
            CNode node = (CNode)e.getValue();
            if (node instanceof LeafCNode) {
                InstanceResolver.setLeafValueIfUnset(targetDef, builder, (LeafCNode)node);
                continue;
            }
            if (!(node instanceof InnerCNode) || !InstanceResolver.hasField(builder.getClass(), node.getName())) continue;
            Field innerField = builder.getClass().getDeclaredField(node.getName());
            innerField.setAccessible(true);
            Object innerFieldVal = innerField.get(builder);
            if (innerFieldVal instanceof List) {
                List innerList = (List)innerFieldVal;
                for (Object b : innerList) {
                    if (!(b instanceof ConfigBuilder)) continue;
                    InstanceResolver.applyDef((ConfigBuilder)b, (InnerCNode)node);
                }
                continue;
            }
            if (!(innerFieldVal instanceof ConfigBuilder)) continue;
            InstanceResolver.applyDef((ConfigBuilder)innerFieldVal, (InnerCNode)node);
        }
    }

    private static boolean hasField(Class<?> aClass, String name) {
        for (Field field : aClass.getDeclaredFields()) {
            if (!name.equals(field.getName())) continue;
            return true;
        }
        return false;
    }

    private static void setLeafValueIfUnset(InnerCNode targetDef, Object builder, LeafCNode node) throws Exception {
        if (InstanceResolver.hasField(builder.getClass(), node.getName())) {
            Field field = builder.getClass().getDeclaredField(node.getName());
            field.setAccessible(true);
            Object val = field.get(builder);
            if (val == null) {
                try {
                    if (node.getDefaultValue() != null) {
                        Method setter = builder.getClass().getDeclaredMethod(node.getName(), String.class);
                        setter.setAccessible(true);
                        setter.invoke(builder, node.getDefaultValue().getValue());
                    }
                }
                catch (Exception e) {
                    log.severe("For config '" + targetDef.getFullName() + "': Unable to apply the default value for field '" + node.getName() + "' to config Builder (where it wasn't set): " + Exceptions.toMessageString((Throwable)e));
                }
            }
        }
    }

    private static Class<? extends ConfigInstance> getConfigClass(ConfigDefinitionKey cKey, ClassLoader instanceLoader) {
        Class<?> clazz;
        String className = ConfiggenUtil.createClassName((String)cKey.getName());
        String fullClassName = InstanceResolver.packageName(cKey) + "." + className;
        try {
            clazz = instanceLoader != null ? instanceLoader.loadClass(fullClassName) : Class.forName(fullClassName);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationRuntimeException("Could not find config class for key " + cKey, (Throwable)e);
        }
        if (!ConfigInstance.class.isAssignableFrom(clazz)) {
            throw new ConfigurationRuntimeException(fullClassName + " is not a ConfigInstance subclass, can not produce config for " + cKey);
        }
        return clazz;
    }

    static String packageName(ConfigDefinitionKey cKey) {
        String prefix = "com.yahoo.";
        return prefix + (cKey.getNamespace().isEmpty() ? "config" : cKey.getNamespace());
    }
}

