/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model.test;

import com.google.common.annotations.Beta;
import com.yahoo.component.Version;
import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.model.MapConfigModelRegistry;
import com.yahoo.config.model.application.provider.BaseDeployLogger;
import com.yahoo.config.model.application.provider.SchemaValidators;
import com.yahoo.config.model.builder.xml.ConfigModelBuilder;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.test.MockApplicationPackage;
import com.yahoo.config.model.test.TestRoot;
import com.yahoo.vespa.model.VespaModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.SAXException;

@Beta
public class TestDriver {
    private final List<ConfigModelBuilder> builders = new ArrayList<ConfigModelBuilder>();
    private final boolean validate;

    public TestDriver(boolean validate) {
        this.validate = validate;
    }

    public TestDriver() {
        this(false);
    }

    public TestDriver addBuilder(ConfigModelBuilder builder) {
        this.builders.add(builder);
        return this;
    }

    public TestRoot buildModel(String servicesXml) {
        return this.buildModel(servicesXml, "<hosts><host name='localhost'><alias>mockhost</alias></host></hosts>");
    }

    public TestRoot buildModel(String servicesXml, String hostsXml) {
        if (!servicesXml.contains("<services")) {
            servicesXml = "<services version='1.0'>" + servicesXml + "</services>";
        }
        return this.buildModel(new MockApplicationPackage.Builder().withHosts(hostsXml).withServices(servicesXml).build());
    }

    public TestRoot buildModel(ApplicationPackage applicationPackage) {
        return this.buildModel(new DeployState.Builder().applicationPackage(applicationPackage).build(true));
    }

    public TestRoot buildModel(DeployState deployState) {
        MapConfigModelRegistry registry = new MapConfigModelRegistry(this.builders);
        try {
            this.validate(deployState.getApplicationPackage());
            return new TestRoot(new VespaModel(registry, deployState));
        }
        catch (IOException | SAXException e) {
            throw new RuntimeException(e);
        }
    }

    private void validate(ApplicationPackage appPkg) throws IOException {
        if (!this.validate) {
            return;
        }
        SchemaValidators schemaValidators = new SchemaValidators(new Version(6), (DeployLogger)new BaseDeployLogger());
        if (appPkg.getHosts() != null) {
            schemaValidators.hostsXmlValidator().validate(appPkg.getHosts());
        }
        schemaValidators.servicesXmlValidator().validate(appPkg.getServices());
    }
}

