/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.filedistribution;

import com.yahoo.config.application.api.FileRegistry;
import com.yahoo.config.model.api.ConfigServerSpec;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.vespa.model.Host;
import com.yahoo.vespa.model.admin.FileDistributionOptions;
import com.yahoo.vespa.model.filedistribution.FileDistributor;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

public class FileDistributionConfigProducer
extends AbstractConfigProducer {
    private final Map<Host, AbstractConfigProducer> fileDistributionConfigProducers = new IdentityHashMap<Host, AbstractConfigProducer>();
    private final FileDistributor fileDistributor;
    private final FileDistributionOptions options;

    private FileDistributionConfigProducer(AbstractConfigProducer parent, FileDistributor fileDistributor, FileDistributionOptions options) {
        super(parent, "filedistribution");
        this.fileDistributor = fileDistributor;
        this.options = options;
    }

    public FileDistributor getFileDistributor() {
        return this.fileDistributor;
    }

    public FileDistributionOptions getOptions() {
        return this.options;
    }

    public void addFileDistributionConfigProducer(Host host, AbstractConfigProducer fileDistributionConfigProducer) {
        this.fileDistributionConfigProducers.put(host, fileDistributionConfigProducer);
    }

    public AbstractConfigProducer getConfigProducer(Host host) {
        return this.fileDistributionConfigProducers.get(host);
    }

    public static class Builder {
        private final FileDistributionOptions options;

        public Builder(FileDistributionOptions fileDistributionOptions) {
            this.options = fileDistributionOptions;
        }

        public FileDistributionConfigProducer build(AbstractConfigProducer ancestor, FileRegistry fileRegistry, List<ConfigServerSpec> configServerSpec) {
            FileDistributor fileDistributor = new FileDistributor(fileRegistry, configServerSpec);
            return new FileDistributionConfigProducer(ancestor, fileDistributor, this.options);
        }
    }
}

