/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.content.engines;

import com.yahoo.vespa.config.content.core.StorServerConfig;
import com.yahoo.vespa.config.storage.StorMemfilepersistenceConfig;
import com.yahoo.vespa.model.builder.xml.dom.ModelElement;
import com.yahoo.vespa.model.content.StorageGroup;
import com.yahoo.vespa.model.content.StorageNode;
import com.yahoo.vespa.model.content.cluster.ContentCluster;
import com.yahoo.vespa.model.content.engines.PersistenceEngine;

public class VDSEngine
extends PersistenceEngine
implements StorMemfilepersistenceConfig.Producer {
    ModelElement tuning;

    public VDSEngine(StorageNode parent, ModelElement vdsConfig) {
        super(parent, "provider");
        if (vdsConfig != null) {
            this.tuning = vdsConfig.getChild("tuning");
        }
        if (parent != null) {
            parent.useVdsEngine();
        }
    }

    public void getConfig(StorMemfilepersistenceConfig.Builder builder) {
        ModelElement cacheSize;
        if (this.tuning == null) {
            return;
        }
        ModelElement diskFullRatio = this.tuning.getChild("disk-full-ratio");
        if (diskFullRatio != null) {
            builder.disk_full_factor(diskFullRatio.asDouble());
        }
        if ((cacheSize = this.tuning.getChild("cache-size")) != null) {
            builder.cache_size(cacheSize.asLong());
        }
    }

    public void getConfig(StorServerConfig.Builder builder) {
        builder.persistence_provider(new StorServerConfig.Persistence_provider.Builder().type(StorServerConfig.Persistence_provider.Type.Enum.STORAGE));
    }

    public static class Factory
    implements PersistenceEngine.PersistenceFactory {
        ModelElement vdsConfig;

        public Factory(ModelElement vdsConfig) {
            this.vdsConfig = vdsConfig;
        }

        @Override
        public PersistenceEngine create(StorageNode storageNode, StorageGroup parentGroup, ModelElement storageNodeElement) {
            return new VDSEngine(storageNode, this.vdsConfig);
        }

        @Override
        public boolean supportRevert() {
            return true;
        }

        @Override
        public boolean enableMultiLevelSplitting() {
            return true;
        }

        @Override
        public ContentCluster.DistributionMode getDefaultDistributionMode() {
            return ContentCluster.DistributionMode.STRICT;
        }
    }
}

