/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.builder.xml.dom;

import com.yahoo.binaryprefix.BinaryScaledAmount;
import com.yahoo.text.XML;
import com.yahoo.vespa.model.admin.FileDistributionOptions;
import com.yahoo.vespa.model.builder.xml.dom.BinaryScaledAmountParser;
import java.util.Optional;
import org.w3c.dom.Element;

public class DomFileDistributionOptionsBuilder {
    private final FileDistributionOptions fileDistributionOptions;

    public DomFileDistributionOptionsBuilder(FileDistributionOptions fileDistributionOptions) {
        this.fileDistributionOptions = fileDistributionOptions;
    }

    private static void throwExceptionForElementInFileDistribution(String subElement, String reason) {
        throw new RuntimeException("In element '" + subElement + "' contained in 'filedistribution': " + reason);
    }

    private Optional<BinaryScaledAmount> getAmount(String name, Element fileDistributionElement) {
        Element optionElement = XML.getChild((Element)fileDistributionElement, (String)name);
        try {
            if (optionElement != null) {
                String valueString = XML.getValue((Element)optionElement);
                return Optional.of(BinaryScaledAmountParser.parse(valueString));
            }
        }
        catch (NumberFormatException e) {
            DomFileDistributionOptionsBuilder.throwExceptionForElementInFileDistribution(name, "Expected a valid number. (Message = " + e.getMessage() + ").");
        }
        return Optional.empty();
    }

    public FileDistributionOptions build(Element fileDistributionElement) {
        if (fileDistributionElement != null) {
            this.getAmount("uploadbitrate", fileDistributionElement).ifPresent(this.fileDistributionOptions::uploadBitRate);
            this.getAmount("downloadbitrate", fileDistributionElement).ifPresent(this.fileDistributionOptions::downloadBitRate);
            Element disable = XML.getChild((Element)fileDistributionElement, (String)"disabled");
            if (disable == null) {
                disable = XML.getChild((Element)fileDistributionElement, (String)"disableFiledistributor");
            }
            if (disable != null) {
                this.fileDistributionOptions.disableFiledistributor(Boolean.valueOf(XML.getValue((Element)disable)));
            }
        }
        return this.fileDistributionOptions;
    }
}

