/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.admin;

import com.yahoo.binaryprefix.BinaryPrefix;
import com.yahoo.binaryprefix.BinaryScaledAmount;
import com.yahoo.cloud.config.filedistribution.FiledistributorConfig;

public class FileDistributionOptions
implements FiledistributorConfig.Producer {
    private BinaryScaledAmount uploadBitRate = new BinaryScaledAmount();
    private BinaryScaledAmount downloadBitRate = new BinaryScaledAmount();
    private boolean disableFiledistributor = false;

    public static FileDistributionOptions defaultOptions() {
        return new FileDistributionOptions();
    }

    private FileDistributionOptions() {
    }

    public void downloadBitRate(BinaryScaledAmount amount) {
        this.ensureNonNegative(amount);
        this.downloadBitRate = amount;
    }

    public void uploadBitRate(BinaryScaledAmount amount) {
        this.ensureNonNegative(amount);
        this.uploadBitRate = amount;
    }

    public void disableFiledistributor(boolean value) {
        this.disableFiledistributor = value;
    }

    public boolean disableFiledistributor() {
        return this.disableFiledistributor;
    }

    private void ensureNonNegative(BinaryScaledAmount amount) {
        if (amount.amount < 0.0) {
            throw new IllegalArgumentException("Expected non-negative number, got " + amount.amount);
        }
    }

    private int byteRate(BinaryScaledAmount bitRate) {
        BinaryScaledAmount byteRate = bitRate.divide(8.0);
        return (int)byteRate.as(BinaryPrefix.unit);
    }

    public void getConfig(FiledistributorConfig.Builder builder) {
        builder.maxuploadspeed((double)this.byteRate(this.uploadBitRate));
        builder.maxdownloadspeed((double)this.byteRate(this.downloadBitRate));
    }
}

