/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.document.SDField;
import com.yahoo.searchdefinition.processing.Processor;
import com.yahoo.searchdefinition.processing.multifieldresolver.IndexCommandResolver;
import com.yahoo.searchdefinition.processing.multifieldresolver.RankTypeResolver;
import com.yahoo.searchdefinition.processing.multifieldresolver.StemmingResolver;
import com.yahoo.vespa.model.container.search.QueryProfiles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MultifieldIndexHarmonizer
extends Processor {
    private Map<String, List<SDField>> indexToFields = new HashMap<String, List<SDField>>();

    public MultifieldIndexHarmonizer(Search search, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(search, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process() {
        this.populateIndexToFields(this.search);
        this.resolveAllConflicts(this.search);
    }

    private void populateIndexToFields(Search search) {
        for (SDField field : search.allConcreteFields()) {
            if (!field.doesIndexing()) continue;
            Iterator<String> j = field.getFieldNameAsIterator();
            while (j.hasNext()) {
                String indexName = j.next();
                this.addIndexField(indexName, field);
            }
        }
    }

    private void addIndexField(String indexName, SDField field) {
        List<SDField> fields = this.indexToFields.get(indexName);
        if (fields == null) {
            fields = new ArrayList<SDField>();
            this.indexToFields.put(indexName, fields);
        }
        fields.add(field);
    }

    private void resolveAllConflicts(Search search) {
        for (Map.Entry<String, List<SDField>> entry : this.indexToFields.entrySet()) {
            String indexName = entry.getKey();
            List<SDField> fields = entry.getValue();
            if (fields.size() == 1) continue;
            this.resolveConflicts(indexName, fields, search);
        }
    }

    private void resolveConflicts(String indexName, List<SDField> fields, Search search) {
        new StemmingResolver(indexName, fields, search, this.deployLogger).resolve();
        new IndexCommandResolver(indexName, fields, search, this.deployLogger).resolve();
        new RankTypeResolver(indexName, fields, search, this.deployLogger).resolve();
    }
}

