/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model.deploy;

import com.yahoo.config.model.api.ConfigServerSpec;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.HostName;
import com.yahoo.config.provision.Version;
import com.yahoo.config.provision.Zone;
import java.util.ArrayList;
import java.util.List;

public class DeployProperties {
    private final boolean multitenant;
    private final ApplicationId applicationId;
    private final List<ConfigServerSpec> serverSpecs = new ArrayList<ConfigServerSpec>();
    private final HostName loadBalancerName;
    private final boolean hostedVespa;
    private final Version vespaVersion;
    private final Zone zone;

    private DeployProperties(boolean multitenant, ApplicationId applicationId, List<ConfigServerSpec> configServerSpecs, HostName loadBalancerName, boolean hostedVespa, Version vespaVersion, Zone zone) {
        this.loadBalancerName = loadBalancerName;
        this.vespaVersion = vespaVersion;
        this.zone = zone;
        this.multitenant = multitenant || hostedVespa || Boolean.getBoolean("multitenant");
        this.applicationId = applicationId;
        this.serverSpecs.addAll(configServerSpecs);
        this.hostedVespa = hostedVespa;
    }

    public boolean multitenant() {
        return this.multitenant;
    }

    public ApplicationId applicationId() {
        return this.applicationId;
    }

    public List<ConfigServerSpec> configServerSpecs() {
        return this.serverSpecs;
    }

    public HostName loadBalancerName() {
        return this.loadBalancerName;
    }

    public boolean hostedVespa() {
        return this.hostedVespa;
    }

    public Version vespaVersion() {
        return this.vespaVersion;
    }

    public Zone zone() {
        return this.zone;
    }

    public static class Builder {
        private ApplicationId applicationId = ApplicationId.defaultId();
        private boolean multitenant = false;
        private List<ConfigServerSpec> configServerSpecs = new ArrayList<ConfigServerSpec>();
        private HostName loadBalancerName;
        private boolean hostedVespa = false;
        private Version vespaVersion = Version.fromIntValues((int)1, (int)0, (int)0);
        private Zone zone = Zone.defaultZone();

        public Builder applicationId(ApplicationId applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public Builder multitenant(boolean multitenant) {
            this.multitenant = multitenant;
            return this;
        }

        public Builder configServerSpecs(List<ConfigServerSpec> configServerSpecs) {
            this.configServerSpecs = configServerSpecs;
            return this;
        }

        public Builder loadBalancerName(HostName loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
            return this;
        }

        public Builder vespaVersion(Version version) {
            this.vespaVersion = version;
            return this;
        }

        public Builder hostedVespa(boolean hostedVespa) {
            this.hostedVespa = hostedVespa;
            return this;
        }

        public Builder zone(Zone zone) {
            this.zone = zone;
            return this;
        }

        public DeployProperties build() {
            return new DeployProperties(this.multitenant, this.applicationId, this.configServerSpecs, this.loadBalancerName, this.hostedVespa, this.vespaVersion, this.zone);
        }
    }
}

