/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.content;

import com.yahoo.vespa.config.content.core.StorDistributormanagerConfig;
import com.yahoo.vespa.model.builder.xml.dom.ModelElement;
import com.yahoo.vespa.model.content.cluster.ContentCluster;

public class BucketSplitting
implements StorDistributormanagerConfig.Producer {
    Integer maxDocuments;
    Integer splitSize;
    Integer minSplitCount;
    boolean useInlineBucketSplitting;

    public BucketSplitting(boolean useInlineBucketSplitting, Integer maxDocuments, Integer splitSize, Integer minSplitCount) {
        this.maxDocuments = maxDocuments;
        this.splitSize = splitSize;
        this.minSplitCount = minSplitCount;
        this.useInlineBucketSplitting = useInlineBucketSplitting;
    }

    public void getConfig(StorDistributormanagerConfig.Builder builder) {
        if (this.maxDocuments != null) {
            builder.splitcount(this.maxDocuments.intValue());
            builder.joincount(this.maxDocuments / 2);
        }
        if (this.splitSize != null) {
            builder.splitsize(this.splitSize.intValue());
            builder.joinsize(this.splitSize / 2);
        }
        if (this.minSplitCount != null) {
            builder.minsplitcount(this.minSplitCount.intValue());
        }
        builder.inlinebucketsplitting(this.useInlineBucketSplitting);
    }

    public static class Builder {
        public BucketSplitting build(ContentCluster cluster, ModelElement clusterElem) {
            ModelElement tuning = clusterElem.getChild("tuning");
            if (tuning == null) {
                return new BucketSplitting(cluster.isMemfilePersistence(), null, null, null);
            }
            ModelElement bucketSplitting = tuning.getChild("bucket-splitting");
            if (bucketSplitting != null) {
                Integer maxDocuments = bucketSplitting.getIntegerAttribute("max-documents");
                Integer splitSize = bucketSplitting.getIntegerAttribute("max-size");
                Integer minSplitCount = bucketSplitting.getIntegerAttribute("minimum-bits");
                return new BucketSplitting(cluster.isMemfilePersistence(), maxDocuments, splitSize, minSplitCount);
            }
            return new BucketSplitting(cluster.isMemfilePersistence(), null, null, null);
        }
    }
}

