/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.xml;

import com.yahoo.collections.CollectionUtil;
import com.yahoo.config.model.builder.xml.XmlHelper;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.container.core.AccessLogConfig;
import com.yahoo.vespa.model.builder.xml.dom.VespaDomBuilder;
import com.yahoo.vespa.model.container.ContainerCluster;
import com.yahoo.vespa.model.container.component.AccessLogComponent;
import com.yahoo.vespa.model.container.xml.InconsistentSchemaAndCodeError;
import java.util.Optional;
import org.w3c.dom.Element;

public class AccessLogBuilder {
    public static Optional<AccessLogComponent> buildIfNotDisabled(ContainerCluster cluster, Element accessLogSpec) {
        AccessLogTypeLiteral typeLiteral = XmlHelper.getOptionalAttribute(accessLogSpec, "type").map(AccessLogTypeLiteral::fromAttributeValue).orElse(AccessLogTypeLiteral.VESPA);
        switch (typeLiteral) {
            case DISABLED: {
                return Optional.empty();
            }
            case VESPA: {
                return Optional.of(new DomBuilder(AccessLogComponent.AccessLogType.queryAccessLog).build(cluster, accessLogSpec));
            }
            case YAPACHE: {
                return Optional.of(new DomBuilder(AccessLogComponent.AccessLogType.yApacheAccessLog).build(cluster, accessLogSpec));
            }
            case JSON: {
                return Optional.of(new DomBuilder(AccessLogComponent.AccessLogType.jsonAccessLog).build(cluster, accessLogSpec));
            }
        }
        throw new InconsistentSchemaAndCodeError();
    }

    private static class DomBuilder
    extends VespaDomBuilder.DomConfigProducerBuilder<AccessLogComponent> {
        private final AccessLogComponent.AccessLogType accessLogType;

        public DomBuilder(AccessLogComponent.AccessLogType accessLogType) {
            this.accessLogType = accessLogType;
        }

        @Override
        protected AccessLogComponent doBuild(AbstractConfigProducer ancestor, Element spec) {
            return new AccessLogComponent(this.accessLogType, this.fileNamePattern(spec), this.rotationInterval(spec), this.rotationScheme(spec), this.symlinkName(spec));
        }

        private String symlinkName(Element spec) {
            return XmlHelper.nullIfEmpty(spec.getAttribute("symlinkName"));
        }

        private AccessLogConfig.FileHandler.RotateScheme.Enum rotationScheme(Element spec) {
            return AccessLogComponent.rotateScheme(XmlHelper.nullIfEmpty(spec.getAttribute("rotationScheme")));
        }

        private String rotationInterval(Element spec) {
            return XmlHelper.nullIfEmpty(spec.getAttribute("rotationInterval"));
        }

        private String fileNamePattern(Element spec) {
            return XmlHelper.nullIfEmpty(spec.getAttribute("fileNamePattern"));
        }
    }

    private static enum AccessLogTypeLiteral {
        VESPA("vespa"),
        YAPACHE("yapache"),
        JSON("json"),
        DISABLED("disabled");

        final String attributeValue;

        private AccessLogTypeLiteral(String attributeValue) {
            this.attributeValue = attributeValue;
        }

        static AccessLogTypeLiteral fromAttributeValue(String value) {
            return (AccessLogTypeLiteral)((Object)CollectionUtil.firstMatching((Object[])AccessLogTypeLiteral.values(), typeLiteral -> typeLiteral.attributeValue.equals(value)).get());
        }
    }
}

