/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.builder.xml.dom.chains;

import com.yahoo.component.chain.model.ChainSpecification;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.vespa.model.builder.xml.dom.VespaDomBuilder;
import com.yahoo.vespa.model.builder.xml.dom.chains.ChainSpecificationBuilder;
import com.yahoo.vespa.model.builder.xml.dom.chains.ComponentsBuilder;
import com.yahoo.vespa.model.container.component.chain.Chain;
import com.yahoo.vespa.model.container.component.chain.ChainedComponent;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.w3c.dom.Element;

public abstract class DomChainBuilderBase<COMPONENT extends ChainedComponent<?>, CHAIN extends Chain<COMPONENT>>
extends VespaDomBuilder.DomConfigProducerBuilder<CHAIN> {
    private Collection<ComponentsBuilder.ComponentType<COMPONENT>> allowedComponentTypes;
    protected final Map<String, ComponentsBuilder.ComponentType> outerComponentTypeByComponentName;

    public DomChainBuilderBase(Collection<ComponentsBuilder.ComponentType<COMPONENT>> allowedComponentTypes, Map<String, ComponentsBuilder.ComponentType> outerComponentTypeByComponentName) {
        this.allowedComponentTypes = allowedComponentTypes;
        this.outerComponentTypeByComponentName = outerComponentTypeByComponentName;
    }

    @Override
    public final CHAIN doBuild(AbstractConfigProducer ancestor, Element producerSpec) {
        ComponentsBuilder componentsBuilder = new ComponentsBuilder(ancestor, this.allowedComponentTypes, Arrays.asList(producerSpec), this.outerComponentTypeByComponentName);
        ChainSpecification specWithoutInnerComponents = new ChainSpecificationBuilder(producerSpec).build(componentsBuilder.getOuterComponentReferences());
        CHAIN chain = this.buildChain(ancestor, producerSpec, specWithoutInnerComponents);
        this.addInnerComponents(chain, componentsBuilder.getComponentDefinitions());
        return chain;
    }

    private void addInnerComponents(CHAIN chain, Collection<COMPONENT> componentDefinitions) {
        for (ChainedComponent innerComponent : componentDefinitions) {
            ((Chain)chain).addInnerComponent((ChainedComponent)innerComponent);
        }
    }

    protected abstract CHAIN buildChain(AbstractConfigProducer var1, Element var2, ChainSpecification var3);
}

