/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.builder.xml.dom;

import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.osgi.provider.model.ComponentModel;
import com.yahoo.text.XML;
import com.yahoo.vespa.model.builder.xml.dom.VespaDomBuilder;
import com.yahoo.vespa.model.container.component.Servlet;
import com.yahoo.vespa.model.container.component.ServletProvider;
import com.yahoo.vespa.model.container.component.SimpleComponent;
import com.yahoo.vespa.model.container.xml.BundleInstantiationSpecificationBuilder;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;

public class ServletBuilder
extends VespaDomBuilder.DomConfigProducerBuilder<Servlet> {
    @Override
    protected ServletProvider doBuild(AbstractConfigProducer ancestor, Element servletElement) {
        SimpleComponent servlet = this.createServletComponent(servletElement);
        ServletProvider servletProvider = this.createServletProvider(servletElement, servlet);
        return servletProvider;
    }

    private SimpleComponent createServletComponent(Element servletElement) {
        ComponentModel componentModel = new ComponentModel(BundleInstantiationSpecificationBuilder.build(servletElement, false));
        return new SimpleComponent(componentModel);
    }

    private ServletProvider createServletProvider(Element servletElement, SimpleComponent servlet) {
        Map<String, String> servletConfig = this.getServletConfig(servletElement);
        return new ServletProvider(servlet, this.getPath(servletElement), servletConfig);
    }

    private String getPath(Element servletElement) {
        Element pathElement = XML.getChild((Element)servletElement, (String)"path");
        return XML.getValue((Element)pathElement);
    }

    private Map<String, String> getServletConfig(Element servletElement) {
        HashMap<String, String> servletConfig = new HashMap<String, String>();
        Element servletConfigElement = XML.getChild((Element)servletElement, (String)"servlet-config");
        XML.getChildren((Element)servletConfigElement).forEach(parameter -> servletConfig.put(parameter.getTagName(), XML.getValue((Element)parameter)));
        return servletConfig;
    }
}

