/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation;

import com.yahoo.collections.Pair;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.InnerNode;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.io.IOUtils;
import com.yahoo.log.InvalidLogFormatException;
import com.yahoo.log.LogLevel;
import com.yahoo.log.LogMessage;
import com.yahoo.system.ProcessExecuter;
import com.yahoo.text.StringUtilities;
import com.yahoo.vespa.config.search.AttributesConfig;
import com.yahoo.vespa.config.search.ImportedFieldsConfig;
import com.yahoo.vespa.config.search.IndexschemaConfig;
import com.yahoo.vespa.config.search.RankProfilesConfig;
import com.yahoo.vespa.config.search.core.RankingConstantsConfig;
import com.yahoo.vespa.model.VespaModel;
import com.yahoo.vespa.model.application.validation.Validator;
import com.yahoo.vespa.model.search.AbstractSearchCluster;
import com.yahoo.vespa.model.search.DocumentDatabase;
import com.yahoo.vespa.model.search.IndexedSearchCluster;
import com.yahoo.vespa.model.search.SearchCluster;
import com.yahoo.yolean.Exceptions;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RankSetupValidator
extends Validator {
    private static final Logger log = Logger.getLogger(RankSetupValidator.class.getName());
    private final boolean force;

    public RankSetupValidator(boolean force) {
        this.force = force;
    }

    @Override
    public void validate(VespaModel model, DeployState deployState) {
        try {
            File cfgDir = Files.createTempDirectory("deploy_ranksetup", new FileAttribute[0]).toFile();
            for (AbstractSearchCluster cluster : model.getSearchClusters()) {
                if (!cluster.isRealtime()) continue;
                IndexedSearchCluster sc = (IndexedSearchCluster)cluster;
                String clusterDir = cfgDir.getAbsolutePath() + "/" + sc.getClusterName() + "/";
                for (DocumentDatabase docDb : sc.getDocumentDbs()) {
                    String name = docDb.getDerivedConfiguration().getSearch().getName();
                    String searchDir = clusterDir + name + "/";
                    this.writeConfigs(searchDir, docDb);
                    if (this.validate("dir:" + searchDir, sc, name, deployState.getDeployLogger(), cfgDir)) continue;
                    return;
                }
            }
            this.deleteTempDir(cfgDir);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean validate(String configId, SearchCluster searchCluster, String sdName, DeployLogger deployLogger, File tempDir) {
        Instant start = Instant.now();
        try {
            boolean ret = this.execValidate(configId, searchCluster, sdName, deployLogger);
            if (!ret) {
                this.deleteTempDir(tempDir);
            }
            log.log((Level)LogLevel.DEBUG, String.format("Validating %s for %s, %s took %s ms", sdName, searchCluster, configId, Duration.between(start, Instant.now()).toMillis()));
            return ret;
        }
        catch (IllegalArgumentException e) {
            this.deleteTempDir(tempDir);
            throw e;
        }
    }

    private void deleteTempDir(File dir) {
        if (!IOUtils.recursiveDeleteDir((File)dir)) {
            throw new RuntimeException("Failed deleting " + dir);
        }
    }

    private void writeConfigs(String dir, AbstractConfigProducer producer) throws IOException {
        RankProfilesConfig.Builder rpcb = new RankProfilesConfig.Builder();
        ((RankProfilesConfig.Producer)RankProfilesConfig.Producer.class.cast(producer)).getConfig(rpcb);
        RankProfilesConfig rpc = new RankProfilesConfig(rpcb);
        RankSetupValidator.writeConfig(dir, RankProfilesConfig.getDefName() + ".cfg", (ConfigInstance)rpc);
        IndexschemaConfig.Builder iscb = new IndexschemaConfig.Builder();
        ((IndexschemaConfig.Producer)IndexschemaConfig.Producer.class.cast(producer)).getConfig(iscb);
        IndexschemaConfig isc = new IndexschemaConfig(iscb);
        RankSetupValidator.writeConfig(dir, IndexschemaConfig.getDefName() + ".cfg", (ConfigInstance)isc);
        AttributesConfig.Builder acb = new AttributesConfig.Builder();
        ((AttributesConfig.Producer)AttributesConfig.Producer.class.cast(producer)).getConfig(acb);
        AttributesConfig ac = new AttributesConfig(acb);
        RankSetupValidator.writeConfig(dir, AttributesConfig.getDefName() + ".cfg", (ConfigInstance)ac);
        RankingConstantsConfig.Builder rccb = new RankingConstantsConfig.Builder();
        ((RankingConstantsConfig.Producer)RankingConstantsConfig.Producer.class.cast(producer)).getConfig(rccb);
        RankingConstantsConfig rcc = new RankingConstantsConfig(rccb);
        RankSetupValidator.writeConfig(dir, RankingConstantsConfig.getDefName() + ".cfg", (ConfigInstance)rcc);
        ImportedFieldsConfig.Builder ifcb = new ImportedFieldsConfig.Builder();
        ((ImportedFieldsConfig.Producer)ImportedFieldsConfig.Producer.class.cast(producer)).getConfig(ifcb);
        ImportedFieldsConfig ifc = new ImportedFieldsConfig(ifcb);
        RankSetupValidator.writeConfig(dir, ImportedFieldsConfig.getDefName() + ".cfg", (ConfigInstance)ifc);
    }

    private static void writeConfig(String dir, String configName, ConfigInstance config) throws IOException {
        IOUtils.writeFile((String)(dir + configName), (String)StringUtilities.implodeMultiline((List)ConfigInstance.serialize((InnerNode)config)), (boolean)false);
    }

    private boolean execValidate(String configId, SearchCluster sc, String sdName, DeployLogger deployLogger) {
        String job = "vespa-verify-ranksetup-bin " + configId;
        ProcessExecuter executer = new ProcessExecuter();
        try {
            Pair ret = executer.exec(job);
            if ((Integer)ret.getFirst() != 0) {
                this.validateFail((String)ret.getSecond(), sc, sdName, deployLogger);
            }
        }
        catch (IOException e) {
            this.validateWarn(e, deployLogger);
            return false;
        }
        return true;
    }

    private void validateWarn(Exception e, DeployLogger deployLogger) {
        String msg = "Unable to execute 'vespa-verify-ranksetup', validation of rank expressions will only take place when you start Vespa: " + Exceptions.toMessageString((Throwable)e);
        deployLogger.log(LogLevel.WARNING, msg);
    }

    private void validateFail(String output, SearchCluster sc, String sdName, DeployLogger deployLogger) {
        String errMsg = "For search cluster '" + sc.getClusterName() + "', search definition '" + sdName + "': error in rank setup. Details:\n";
        for (String line : output.split("\n")) {
            if (line.startsWith("debug\t")) continue;
            try {
                LogMessage logmsg = LogMessage.parseNativeFormat((String)line);
                errMsg = errMsg + logmsg.getLevel() + ": " + logmsg.getPayload() + "\n";
            }
            catch (InvalidLogFormatException e) {
                errMsg = errMsg + line + "\n";
            }
        }
        if (!this.force) {
            throw new IllegalArgumentException(errMsg);
        }
        deployLogger.log(LogLevel.WARNING, errMsg + "(Continuing because of force.)");
    }
}

