/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.admin.monitoring;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.concurrent.Immutable;

@Immutable
public class Metric {
    public final String name;
    public final String outputName;
    public final String description;
    public final Map<String, String> dimensions;

    public Metric(String name, String outputName, String description, Map<String, String> dimensions) {
        this.name = name;
        this.outputName = outputName;
        this.description = description;
        this.dimensions = Collections.unmodifiableMap(dimensions);
    }

    public Metric(String name, String outputName, String description) {
        this(name, outputName, description, new HashMap<String, String>());
    }

    public Metric(String name, String outputName) {
        this(name, outputName, "");
    }

    public Metric(String name) {
        this(name, name);
    }

    public Metric addDimensionsFrom(Metric other) {
        LinkedHashMap<String, String> combined = new LinkedHashMap<String, String>(this.dimensions);
        other.dimensions.forEach((k, v) -> {
            if (!combined.containsKey(k)) {
                combined.put((String)k, (String)v);
            }
        });
        return new Metric(this.name, this.outputName, this.description, combined);
    }

    public String toString() {
        return "Metric{name='" + this.name + '\'' + ", outputName='" + this.outputName + '\'' + ", dimensions=" + this.dimensions + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Metric metric = (Metric)o;
        return this.name.equals(metric.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

