/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.document.ArrayDataType;
import com.yahoo.document.DataType;
import com.yahoo.document.StructDataType;
import com.yahoo.document.WeightedSetDataType;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.document.SDField;
import com.yahoo.searchdefinition.processing.Processor;
import com.yahoo.vespa.documentmodel.SummaryField;
import com.yahoo.vespa.documentmodel.SummaryTransform;
import com.yahoo.vespa.model.container.search.QueryProfiles;

public class SummaryDynamicStructsArrays
extends Processor {
    public SummaryDynamicStructsArrays(Search search, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(search, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process() {
        for (SDField field : this.search.allConcreteFields()) {
            DataType type = field.getDataType();
            if (!(type instanceof ArrayDataType) && !(type instanceof WeightedSetDataType) && !(type instanceof StructDataType)) continue;
            for (SummaryField sField : field.getSummaryFields()) {
                if (!sField.getTransform().equals((Object)SummaryTransform.DYNAMICTEASER)) continue;
                throw new IllegalArgumentException("For field '" + field.getName() + "': dynamic summary is illegal for fields of type struct, array or weighted set. Use an explicit summary class with explicit summary fields sourcing from the array/struct/weighted set.");
            }
        }
    }
}

