/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.filedistribution;

import com.yahoo.cloud.config.filedistribution.FiledistributorConfig;
import com.yahoo.cloud.config.filedistribution.FiledistributorrpcConfig;
import com.yahoo.cloud.config.filedistribution.FilereferencesConfig;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.vespa.model.AbstractService;
import com.yahoo.vespa.model.filedistribution.FileDistributionConfigProvider;

public class FileDistributorService
extends AbstractService
implements FiledistributorConfig.Producer,
FiledistributorrpcConfig.Producer,
FilereferencesConfig.Producer {
    static final int BASEPORT = 19092;
    private final FileDistributionConfigProvider configProvider;

    public FileDistributorService(AbstractConfigProducer parent, String hostname, FileDistributionConfigProvider configProvider) {
        super(parent, hostname);
        this.configProvider = configProvider;
        this.portsMeta.on(0).tag("rpc");
        this.portsMeta.on(1).tag("torrent");
        this.portsMeta.on(2).tag("http").tag("state");
        this.setProp("clustertype", "filedistribution");
        this.setProp("clustername", "admin");
    }

    @Override
    public String getStartupCommand() {
        return "exec $ROOT/sbin/vespa-filedistributor --configid " + this.getConfigId();
    }

    @Override
    public boolean getAutostartFlag() {
        return true;
    }

    @Override
    public boolean getAutorestartFlag() {
        return true;
    }

    @Override
    public int getPortCount() {
        return 3;
    }

    @Override
    public int getWantedPort() {
        return 19092;
    }

    public void getConfig(FiledistributorConfig.Builder builder) {
        this.configProvider.getConfig(builder);
    }

    public void getConfig(FiledistributorrpcConfig.Builder builder) {
        this.configProvider.getConfig(builder);
    }

    public void getConfig(FilereferencesConfig.Builder builder) {
        this.configProvider.getConfig(builder);
    }
}

