/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.builder.xml.dom;

import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.text.XML;
import com.yahoo.vespa.model.builder.xml.dom.VespaDomBuilder;
import com.yahoo.vespa.model.search.Tuning;
import java.util.logging.Level;
import org.w3c.dom.Element;

public class DomSearchTuningBuilder
extends VespaDomBuilder.DomConfigProducerBuilder<Tuning> {
    @Override
    protected Tuning doBuild(AbstractConfigProducer parent, Element spec) {
        Tuning tuning = new Tuning(parent);
        for (Element e : XML.getChildren((Element)spec)) {
            if (DomSearchTuningBuilder.equals("dispatch", e)) {
                this.handleDispatch(e, tuning);
                continue;
            }
            if (!DomSearchTuningBuilder.equals("searchnode", e)) continue;
            this.handleSearchNode(parent, e, tuning);
        }
        return tuning;
    }

    private static boolean equals(String name, Element e) {
        return name.equals(e.getNodeName());
    }

    private static String asString(Element e) {
        return e.getFirstChild().getNodeValue();
    }

    private static Long asLong(Element e) {
        return Long.parseLong(e.getFirstChild().getNodeValue());
    }

    private static Integer asInt(Element e) {
        return Integer.parseInt(e.getFirstChild().getNodeValue());
    }

    private static Double asDouble(Element e) {
        return Double.parseDouble(e.getFirstChild().getNodeValue());
    }

    private void handleDispatch(Element spec, Tuning t) {
        t.dispatch = new Tuning.Dispatch();
        for (Element e : XML.getChildren((Element)spec)) {
            if (!DomSearchTuningBuilder.equals("max-hits-per-partition", e)) continue;
            t.dispatch.maxHitsPerPartition = DomSearchTuningBuilder.asInt(e);
        }
    }

    private void handleSearchNode(AbstractConfigProducer parent, Element spec, Tuning t) {
        t.searchNode = new Tuning.SearchNode();
        for (Element e : XML.getChildren((Element)spec)) {
            if (DomSearchTuningBuilder.equals("requestthreads", e)) {
                this.handleRequestThreads(e, t.searchNode);
                continue;
            }
            if (DomSearchTuningBuilder.equals("flushstrategy", e)) {
                this.handleFlushStrategy(parent, e, t.searchNode);
                continue;
            }
            if (DomSearchTuningBuilder.equals("resizing", e)) {
                this.handleResizing(e, t.searchNode);
                continue;
            }
            if (DomSearchTuningBuilder.equals("index", e)) {
                this.handleIndex(e, t.searchNode);
                continue;
            }
            if (DomSearchTuningBuilder.equals("attribute", e)) {
                this.handleAttribute(e, t.searchNode);
                continue;
            }
            if (DomSearchTuningBuilder.equals("summary", e)) {
                this.handleSummary(parent, e, t.searchNode);
                continue;
            }
            if (DomSearchTuningBuilder.equals("initialize", e)) {
                this.handleInitialize(e, t.searchNode);
                continue;
            }
            if (!DomSearchTuningBuilder.equals("feeding", e)) continue;
            this.handleFeeding(e, t.searchNode);
        }
    }

    private void handleRequestThreads(Element spec, Tuning.SearchNode sn) {
        Tuning.SearchNode.RequestThreads rt = sn.threads = new Tuning.SearchNode.RequestThreads();
        for (Element e : XML.getChildren((Element)spec)) {
            if (DomSearchTuningBuilder.equals("search", e)) {
                rt.numSearchThreads = DomSearchTuningBuilder.asInt(e);
                continue;
            }
            if (DomSearchTuningBuilder.equals("persearch", e)) {
                rt.numThreadsPerSearch = DomSearchTuningBuilder.asInt(e);
                continue;
            }
            if (!DomSearchTuningBuilder.equals("summary", e)) continue;
            rt.numSummaryThreads = DomSearchTuningBuilder.asInt(e);
        }
    }

    private void handleFlushStrategy(AbstractConfigProducer parent, Element spec, Tuning.SearchNode sn) {
        for (Element e : XML.getChildren((Element)spec)) {
            if (!DomSearchTuningBuilder.equals("native", e)) continue;
            this.handleNativeStrategy(parent, e, sn);
        }
    }

    private void handleNativeStrategy(AbstractConfigProducer parent, Element spec, Tuning.SearchNode sn) {
        Tuning.SearchNode.FlushStrategy fs = sn.strategy = new Tuning.SearchNode.FlushStrategy();
        for (Element e : XML.getChildren((Element)spec)) {
            if (DomSearchTuningBuilder.equals("total", e)) {
                for (Element subElem : XML.getChildren((Element)e)) {
                    if (DomSearchTuningBuilder.equals("maxmemorygain", subElem)) {
                        fs.totalMaxMemoryGain = DomSearchTuningBuilder.asLong(subElem);
                        continue;
                    }
                    if (!DomSearchTuningBuilder.equals("diskbloatfactor", subElem)) continue;
                    fs.totalDiskBloatFactor = DomSearchTuningBuilder.asDouble(subElem);
                }
                continue;
            }
            if (DomSearchTuningBuilder.equals("component", e)) {
                for (Element subElem : XML.getChildren((Element)e)) {
                    if (DomSearchTuningBuilder.equals("maxmemorygain", subElem)) {
                        fs.componentMaxMemoryGain = DomSearchTuningBuilder.asLong(subElem);
                        continue;
                    }
                    if (DomSearchTuningBuilder.equals("diskbloatfactor", subElem)) {
                        fs.componentDiskBloatFactor = DomSearchTuningBuilder.asDouble(subElem);
                        continue;
                    }
                    if (!DomSearchTuningBuilder.equals("maxage", subElem)) continue;
                    fs.componentMaxage = DomSearchTuningBuilder.asDouble(subElem);
                }
                continue;
            }
            if (DomSearchTuningBuilder.equals("transactionlog", e)) {
                for (Element subElem : XML.getChildren((Element)e)) {
                    if (DomSearchTuningBuilder.equals("maxentries", subElem)) {
                        parent.deployLogger().log(Level.WARNING, "Element 'transactionlog.maxentries is deprecated and ignored in 'native' flush strategy. Use 'transactionlog.maxsize' to limit by size.");
                        continue;
                    }
                    if (!DomSearchTuningBuilder.equals("maxsize", subElem)) continue;
                    fs.transactionLogMaxSize = DomSearchTuningBuilder.asLong(subElem);
                }
                continue;
            }
            if (!DomSearchTuningBuilder.equals("conservative", e)) continue;
            for (Element subElem : XML.getChildren((Element)e)) {
                if (DomSearchTuningBuilder.equals("memory-limit-factor", subElem)) {
                    fs.conservativeMemoryLimitFactor = DomSearchTuningBuilder.asDouble(subElem);
                    continue;
                }
                if (!DomSearchTuningBuilder.equals("disk-limit-factor", subElem)) continue;
                fs.conservativeDiskLimitFactor = DomSearchTuningBuilder.asDouble(subElem);
            }
        }
    }

    private void handleResizing(Element spec, Tuning.SearchNode sn) {
        sn.resizing = new Tuning.SearchNode.Resizing();
        for (Element e : XML.getChildren((Element)spec)) {
            if (!DomSearchTuningBuilder.equals("initialdocumentcount", e)) continue;
            sn.resizing.initialDocumentCount = DomSearchTuningBuilder.asInt(e);
        }
    }

    private void handleIndex(Element spec, Tuning.SearchNode sn) {
        sn.index = new Tuning.SearchNode.Index();
        for (Element e : XML.getChildren((Element)spec)) {
            if (!DomSearchTuningBuilder.equals("io", e)) continue;
            Tuning.SearchNode.Index.Io io = sn.index.io = new Tuning.SearchNode.Index.Io();
            for (Element e2 : XML.getChildren((Element)e)) {
                if (DomSearchTuningBuilder.equals("write", e2)) {
                    io.write = Tuning.SearchNode.IoType.fromString(DomSearchTuningBuilder.asString(e2));
                    continue;
                }
                if (DomSearchTuningBuilder.equals("read", e2)) {
                    io.read = Tuning.SearchNode.IoType.fromString(DomSearchTuningBuilder.asString(e2));
                    continue;
                }
                if (!DomSearchTuningBuilder.equals("search", e2)) continue;
                io.search = Tuning.SearchNode.IoType.fromString(DomSearchTuningBuilder.asString(e2));
            }
        }
    }

    private void handleAttribute(Element spec, Tuning.SearchNode sn) {
        sn.attribute = new Tuning.SearchNode.Attribute();
        for (Element e : XML.getChildren((Element)spec)) {
            if (!DomSearchTuningBuilder.equals("io", e)) continue;
            sn.attribute.io = new Tuning.SearchNode.Attribute.Io();
            for (Element e2 : XML.getChildren((Element)e)) {
                if (!DomSearchTuningBuilder.equals("write", e2)) continue;
                sn.attribute.io.write = Tuning.SearchNode.IoType.fromString(DomSearchTuningBuilder.asString(e2));
            }
        }
    }

    private void handleSummary(AbstractConfigProducer parent, Element spec, Tuning.SearchNode sn) {
        sn.summary = new Tuning.SearchNode.Summary();
        for (Element e : XML.getChildren((Element)spec)) {
            if (DomSearchTuningBuilder.equals("io", e)) {
                sn.summary.io = new Tuning.SearchNode.Summary.Io();
                for (Element e2 : XML.getChildren((Element)e)) {
                    if (DomSearchTuningBuilder.equals("write", e2)) {
                        sn.summary.io.write = Tuning.SearchNode.IoType.fromString(DomSearchTuningBuilder.asString(e2));
                        continue;
                    }
                    if (!DomSearchTuningBuilder.equals("read", e2)) continue;
                    sn.summary.io.read = Tuning.SearchNode.IoType.fromString(DomSearchTuningBuilder.asString(e2));
                }
                continue;
            }
            if (!DomSearchTuningBuilder.equals("store", e)) continue;
            this.handleSummaryStore(parent, e, sn.summary);
        }
    }

    private void handleSummaryStore(AbstractConfigProducer parent, Element spec, Tuning.SearchNode.Summary s) {
        s.store = new Tuning.SearchNode.Summary.Store();
        for (Element e : XML.getChildren((Element)spec)) {
            if (DomSearchTuningBuilder.equals("cache", e)) {
                s.store.cache = new Tuning.SearchNode.Summary.Store.Component();
                this.handleSummaryStoreComponent(parent, e, s.store.cache);
                continue;
            }
            if (!DomSearchTuningBuilder.equals("logstore", e)) continue;
            this.handleSummaryLogStore(parent, e, s.store);
        }
    }

    private void handleSummaryStoreComponent(AbstractConfigProducer parent, Element spec, Tuning.SearchNode.Summary.Store.Component c) {
        for (Element e : XML.getChildren((Element)spec)) {
            if (DomSearchTuningBuilder.equals("maxsize", e)) {
                c.maxSize = DomSearchTuningBuilder.asLong(e);
                continue;
            }
            if (DomSearchTuningBuilder.equals("maxentries", e)) {
                parent.deployLogger().log(Level.WARNING, "Element 'maxentries is deprecated and ignored. Will only limit by size.");
                continue;
            }
            if (DomSearchTuningBuilder.equals("initialentries", e)) {
                c.initialEntries = DomSearchTuningBuilder.asLong(e);
                continue;
            }
            if (!DomSearchTuningBuilder.equals("compression", e)) continue;
            c.compression = new Tuning.SearchNode.Summary.Store.Compression();
            this.handleSummaryStoreCompression(e, c.compression);
        }
    }

    private void handleSummaryStoreCompression(Element spec, Tuning.SearchNode.Summary.Store.Compression c) {
        for (Element e : XML.getChildren((Element)spec)) {
            if (DomSearchTuningBuilder.equals("type", e)) {
                c.type = Tuning.SearchNode.Summary.Store.Compression.Type.fromString(DomSearchTuningBuilder.asString(e));
                continue;
            }
            if (!DomSearchTuningBuilder.equals("level", e)) continue;
            c.level = DomSearchTuningBuilder.asInt(e);
        }
    }

    private void handleSummaryLogStore(AbstractConfigProducer parent, Element spec, Tuning.SearchNode.Summary.Store s) {
        s.logStore = new Tuning.SearchNode.Summary.Store.LogStore();
        for (Element e : XML.getChildren((Element)spec)) {
            if (DomSearchTuningBuilder.equals("maxfilesize", e)) {
                s.logStore.maxFileSize = DomSearchTuningBuilder.asLong(e);
                continue;
            }
            if (DomSearchTuningBuilder.equals("maxdiskbloatfactor", e)) {
                parent.deployLogger().log(Level.WARNING, "Element 'maxdiskbloatfactor is deprecated and ignored. The min value from flush.memory.xxx.diskbloatfactor is used instead");
                continue;
            }
            if (DomSearchTuningBuilder.equals("minfilesizefactor", e)) {
                s.logStore.minFileSizeFactor = DomSearchTuningBuilder.asDouble(e);
                continue;
            }
            if (DomSearchTuningBuilder.equals("numthreads", e)) {
                parent.deployLogger().log(Level.WARNING, "Element 'numthreads is deprecated. Use feeding.concurrency instead.");
                s.logStore.numThreads = DomSearchTuningBuilder.asInt(e);
                continue;
            }
            if (!DomSearchTuningBuilder.equals("chunk", e)) continue;
            s.logStore.chunk = new Tuning.SearchNode.Summary.Store.Component(true);
            this.handleSummaryStoreComponent(parent, e, s.logStore.chunk);
        }
    }

    private void handleInitialize(Element spec, Tuning.SearchNode sn) {
        sn.initialize = new Tuning.SearchNode.Initialize();
        for (Element e : XML.getChildren((Element)spec)) {
            if (!DomSearchTuningBuilder.equals("threads", e)) continue;
            sn.initialize.threads = DomSearchTuningBuilder.asInt(e);
        }
    }

    private void handleFeeding(Element spec, Tuning.SearchNode sn) {
        sn.feeding = new Tuning.SearchNode.Feeding();
        for (Element e : XML.getChildren((Element)spec)) {
            if (!DomSearchTuningBuilder.equals("concurrency", e)) continue;
            sn.feeding.concurrency = DomSearchTuningBuilder.asDouble(e);
        }
    }
}

