/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation.change;

import com.yahoo.config.application.api.ValidationId;
import com.yahoo.config.application.api.ValidationOverrides;
import com.yahoo.config.model.api.ConfigChangeAction;
import com.yahoo.vespa.model.VespaModel;
import com.yahoo.vespa.model.application.validation.change.ChangeValidator;
import com.yahoo.vespa.model.application.validation.change.VespaRefeedAction;
import com.yahoo.vespa.model.content.cluster.ContentCluster;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class IndexingModeChangeValidator
implements ChangeValidator {
    @Override
    public List<ConfigChangeAction> validate(VespaModel currentModel, VespaModel nextModel, ValidationOverrides overrides, Instant now) {
        ArrayList<ConfigChangeAction> actions = new ArrayList<ConfigChangeAction>();
        for (Map.Entry<String, ContentCluster> currentEntry : currentModel.getContentClusters().entrySet()) {
            Optional<ConfigChangeAction> change;
            ContentCluster nextCluster = nextModel.getContentClusters().get(currentEntry.getKey());
            if (nextCluster == null || !(change = this.validateContentCluster(currentEntry.getValue(), nextCluster, overrides, now)).isPresent()) continue;
            actions.add(change.get());
        }
        return actions;
    }

    private Optional<ConfigChangeAction> validateContentCluster(ContentCluster currentCluster, ContentCluster nextCluster, ValidationOverrides overrides, Instant now) {
        boolean nextClusterIsIndexed;
        boolean currentClusterIsIndexed = currentCluster.getSearch().hasIndexedCluster();
        if (currentClusterIsIndexed == (nextClusterIsIndexed = nextCluster.getSearch().hasIndexedCluster())) {
            return Optional.empty();
        }
        return Optional.of(VespaRefeedAction.of(ValidationId.indexModeChange.value(), overrides, "Cluster '" + currentCluster.getName() + "' changed indexing mode from '" + this.indexingMode(currentClusterIsIndexed) + "' to '" + this.indexingMode(nextClusterIsIndexed) + "'", now));
    }

    private String indexingMode(boolean isIndexed) {
        return isIndexed ? "indexed" : "streaming";
    }
}

