/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.admin;

import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.vespa.model.AbstractService;

public class Logserver
extends AbstractService {
    private static final long serialVersionUID = 1L;
    private static final String logArchiveDir = "$ROOT/logs/vespa/logarchive";

    public Logserver(AbstractConfigProducer parent) {
        super(parent, "logserver");
        this.portsMeta.on(0).tag("unused");
        this.portsMeta.on(1).tag("logtp");
        this.portsMeta.on(2).tag("logtp").tag("telnet").tag("last-errors-holder");
        this.portsMeta.on(3).tag("logtp").tag("telnet").tag("replicator");
        this.setProp("clustertype", "admin");
        this.setProp("clustername", "admin");
    }

    @Override
    public String getStartupCommand() {
        return "exec $ROOT/bin/vespa-logserver-start " + this.getMyJVMArgs() + " " + this.getJvmArgs();
    }

    private String getMyJVMArgs() {
        StringBuilder sb = new StringBuilder();
        sb.append("-Dlogserver.listenport=").append(this.getRelativePort(1));
        sb.append(" ");
        sb.append("-Dlogserver.last-errors-holder.port=").append(this.getRelativePort(2));
        sb.append(" ");
        sb.append("-Dlogserver.replicator.port=").append(this.getRelativePort(3));
        sb.append(" ");
        sb.append("-Dlogserver.logarchive.dir=$ROOT/logs/vespa/logarchive");
        return sb.toString();
    }

    @Override
    public int getWantedPort() {
        return 19080;
    }

    @Override
    public boolean requiresWantedPort() {
        return true;
    }

    @Override
    public int getPortCount() {
        return 4;
    }
}

