/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model;

import com.google.inject.Inject;
import com.yahoo.component.provider.ComponentRegistry;
import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.model.ConfigModelRegistry;
import com.yahoo.config.model.MapConfigModelRegistry;
import com.yahoo.config.model.NullConfigModelRegistry;
import com.yahoo.config.model.api.ConfigChangeAction;
import com.yahoo.config.model.api.ConfigModelPlugin;
import com.yahoo.config.model.api.HostProvisioner;
import com.yahoo.config.model.api.Model;
import com.yahoo.config.model.api.ModelContext;
import com.yahoo.config.model.api.ModelCreateResult;
import com.yahoo.config.model.api.ModelFactory;
import com.yahoo.config.model.application.provider.ApplicationPackageXmlFilesValidator;
import com.yahoo.config.model.builder.xml.ConfigModelBuilder;
import com.yahoo.config.model.deploy.DeployProperties;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.provision.Version;
import com.yahoo.config.provision.Zone;
import com.yahoo.vespa.model.VespaModel;
import com.yahoo.vespa.model.application.validation.Validation;
import java.io.File;
import java.io.IOException;
import java.time.Clock;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.xml.sax.SAXException;

public class VespaModelFactory
implements ModelFactory {
    private static final Logger log = Logger.getLogger(VespaModelFactory.class.getName());
    private final ConfigModelRegistry configModelRegistry;
    private final Zone zone;
    private final Clock clock;
    private final Version version;

    @Inject
    public VespaModelFactory(ComponentRegistry<ConfigModelPlugin> pluginRegistry, Zone zone) {
        this(Version.fromIntValues((int)6, (int)185, (int)9), pluginRegistry, zone);
    }

    public VespaModelFactory(Version version, ComponentRegistry<ConfigModelPlugin> pluginRegistry, Zone zone) {
        this.version = version;
        ArrayList<ConfigModelBuilder> modelBuilders = new ArrayList<ConfigModelBuilder>();
        for (ConfigModelPlugin plugin : pluginRegistry.allComponents()) {
            if (!(plugin instanceof ConfigModelBuilder)) continue;
            modelBuilders.add((ConfigModelBuilder)plugin);
        }
        this.configModelRegistry = new MapConfigModelRegistry(modelBuilders);
        this.zone = zone;
        this.clock = Clock.systemUTC();
    }

    public VespaModelFactory(ConfigModelRegistry configModelRegistry) {
        this(configModelRegistry, Clock.systemUTC());
    }

    public VespaModelFactory(ConfigModelRegistry configModelRegistry, Clock clock) {
        this(Version.fromIntValues((int)6, (int)185, (int)9), configModelRegistry, clock);
    }

    public VespaModelFactory(Version version, ConfigModelRegistry configModelRegistry, Clock clock) {
        this.version = version;
        if (configModelRegistry == null) {
            this.configModelRegistry = new NullConfigModelRegistry();
            log.info("Will not load config models from plugins, as no registry is available");
        } else {
            this.configModelRegistry = configModelRegistry;
        }
        this.zone = Zone.defaultZone();
        this.clock = clock;
    }

    public Version getVersion() {
        return this.version;
    }

    public Model createModel(ModelContext modelContext) {
        return this.buildModel(this.createDeployState(modelContext));
    }

    public ModelCreateResult createAndValidateModel(ModelContext modelContext, boolean ignoreValidationErrors) {
        this.validateXml(modelContext, ignoreValidationErrors);
        DeployState deployState = this.createDeployState(modelContext);
        VespaModel model = this.buildModel(deployState);
        List<ConfigChangeAction> changeActions = this.validateModel(model, deployState, ignoreValidationErrors);
        return new ModelCreateResult((Model)model, changeActions);
    }

    private void validateXml(ModelContext modelContext, boolean ignoreValidationErrors) {
        if (modelContext.appDir().isPresent()) {
            ApplicationPackageXmlFilesValidator validator = ApplicationPackageXmlFilesValidator.create((File)((File)modelContext.appDir().get()), (com.yahoo.component.Version)modelContext.modelVespaVersion());
            try {
                validator.checkApplication();
                validator.checkIncludedDirs(modelContext.applicationPackage());
            }
            catch (IllegalArgumentException e) {
                VespaModelFactory.rethrowUnlessIgnoreErrors(e, ignoreValidationErrors);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            this.validateXML(modelContext.applicationPackage(), ignoreValidationErrors);
        }
    }

    private VespaModel buildModel(DeployState deployState) {
        try {
            return new VespaModel(this.configModelRegistry, deployState);
        }
        catch (IOException | SAXException e) {
            throw new RuntimeException(e);
        }
    }

    private DeployState createDeployState(ModelContext modelContext) {
        DeployState.Builder builder = new DeployState.Builder().applicationPackage(modelContext.applicationPackage()).deployLogger(modelContext.deployLogger()).configDefinitionRepo(modelContext.configDefinitionRepo()).fileRegistry(modelContext.getFileRegistry()).permanentApplicationPackage(modelContext.permanentApplicationPackage()).properties(this.createDeployProperties(modelContext.properties())).modelHostProvisioner(VespaModelFactory.createHostProvisioner(modelContext)).rotations(modelContext.properties().rotations()).zone(this.zone).now(this.clock.instant()).wantedNodeVespaVersion(modelContext.wantedNodeVespaVersion()).disableFiledistributor(modelContext.properties().disableFileDistributor());
        modelContext.previousModel().ifPresent(builder::previousModel);
        return builder.build();
    }

    private DeployProperties createDeployProperties(ModelContext.Properties properties) {
        return new DeployProperties.Builder().applicationId(properties.applicationId()).configServerSpecs(properties.configServerSpecs()).loadBalancerName(properties.loadBalancerName()).multitenant(properties.multitenant()).hostedVespa(properties.hostedVespa()).vespaVersion(this.getVersion()).zone(properties.zone()).build();
    }

    private static HostProvisioner createHostProvisioner(ModelContext modelContext) {
        return modelContext.hostProvisioner().orElse(DeployState.getDefaultModelHostProvisioner(modelContext.applicationPackage()));
    }

    private void validateXML(ApplicationPackage applicationPackage, boolean ignoreValidationErrors) {
        try {
            applicationPackage.validateXML();
        }
        catch (IllegalArgumentException e) {
            VespaModelFactory.rethrowUnlessIgnoreErrors(e, ignoreValidationErrors);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private List<ConfigChangeAction> validateModel(VespaModel model, DeployState deployState, boolean ignoreValidationErrors) {
        try {
            return Validation.validate(model, ignoreValidationErrors, deployState);
        }
        catch (IllegalArgumentException e) {
            VespaModelFactory.rethrowUnlessIgnoreErrors(e, ignoreValidationErrors);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new ArrayList<ConfigChangeAction>();
    }

    private static void rethrowUnlessIgnoreErrors(IllegalArgumentException e, boolean ignoreValidationErrors) {
        if (!ignoreValidationErrors) {
            throw e;
        }
    }
}

