/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.filedistribution;

import com.yahoo.config.application.api.FileRegistry;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.vespa.model.Host;
import com.yahoo.vespa.model.admin.FileDistributionOptions;
import com.yahoo.vespa.model.filedistribution.FileDistributor;
import com.yahoo.vespa.model.filedistribution.FileDistributorService;
import java.util.IdentityHashMap;
import java.util.Map;

public class FileDistributionConfigProducer
extends AbstractConfigProducer {
    private final Map<Host, FileDistributorService> fileDistributorServices = new IdentityHashMap<Host, FileDistributorService>();
    private final FileDistributor fileDistributor;
    private final FileDistributionOptions options;

    private FileDistributionConfigProducer(AbstractConfigProducer parent, FileDistributor fileDistributor, FileDistributionOptions options) {
        super(parent, "filedistribution");
        this.fileDistributor = fileDistributor;
        this.options = options;
    }

    public FileDistributorService getFileDistributorService(Host host) {
        FileDistributorService service = this.fileDistributorServices.get(host);
        if (service == null) {
            throw new IllegalStateException("No file distribution service for host " + host);
        }
        return service;
    }

    public FileDistributor getFileDistributor() {
        return this.fileDistributor;
    }

    public FileDistributionOptions getOptions() {
        return this.options;
    }

    public void addFileDistributionService(Host host, FileDistributorService fds) {
        this.fileDistributorServices.put(host, fds);
    }

    public static class Builder {
        private final FileDistributionOptions options;

        public Builder(FileDistributionOptions fileDistributionOptions) {
            this.options = fileDistributionOptions;
        }

        public FileDistributionConfigProducer build(AbstractConfigProducer ancestor, FileRegistry fileRegistry) {
            FileDistributor fileDistributor = new FileDistributor(fileRegistry);
            return new FileDistributionConfigProducer(ancestor, fileDistributor, this.options);
        }
    }
}

